/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.kisso.exception.KissoException;

public class ApiToken {
    private String token;
    private String accessToken;
    private String aesKey;
    private String data;

    protected ApiToken() {
    }

    public ApiToken(String token, String accessToken) {
        this.token = token;
        this.accessToken = this.generateAccessToken(accessToken);
        this.aesKey = RandomUtil.getCharacterAndNumber(43);
    }

    private String generateAccessToken(String accessToken) {
        try {
            SSOConfig config = SSOConfig.getInstance();
            return config.getEncrypt().encrypt(accessToken, config.getSecretkey());
        }
        catch (Exception e) {
            throw new KissoException(e);
        }
    }

    public static String decryptAccessToken(String accessToken) {
        try {
            SSOConfig config = SSOConfig.getInstance();
            return config.getEncrypt().decrypt(accessToken, config.getSecretkey());
        }
        catch (Exception e) {
            throw new KissoException(e);
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAesKey() {
        return this.aesKey;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }
}

