/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.toolkit;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMergeCreator<C, T> {
    private static final Logger log = LoggerFactory.getLogger(ConfigMergeCreator.class);
    private final String configName;
    private final Class<C> configClazz;
    private final Class<T> targetClazz;

    public T create(C global, C item) {
        PropertyDescriptor[] propertyDescriptors;
        T result = this.targetClazz.newInstance();
        BeanInfo beanInfo = Introspector.getBeanInfo(this.configClazz, Object.class);
        for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            Class<?> propertyType = pd.getPropertyType();
            if (Properties.class == propertyType) {
                this.mergeProperties(global, item, result, pd);
                continue;
            }
            this.mergeBasic(global, item, result, pd);
        }
        return result;
    }

    private void mergeProperties(C global, C item, T result, PropertyDescriptor pd) {
        String name = pd.getName();
        Method readMethod = pd.getReadMethod();
        Properties itemValue = (Properties)readMethod.invoke(item, new Object[0]);
        Properties globalValue = (Properties)readMethod.invoke(global, new Object[0]);
        Properties properties = new Properties();
        if (globalValue != null) {
            properties.putAll((Map<?, ?>)globalValue);
        }
        if (itemValue != null) {
            properties.putAll((Map<?, ?>)itemValue);
        }
        if (properties.size() > 0) {
            this.setField(result, name, properties);
        }
    }

    private void mergeBasic(C global, C item, T result, PropertyDescriptor pd) {
        String name = pd.getName();
        Method readMethod = pd.getReadMethod();
        Object value = readMethod.invoke(item, new Object[0]);
        if (value == null) {
            value = readMethod.invoke(global, new Object[0]);
        }
        if (value != null) {
            this.setField(result, name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setField(T result, String name, Object value) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, this.targetClazz);
            Method writeMethod = propertyDescriptor.getWriteMethod();
            writeMethod.invoke(result, value);
        }
        catch (IntrospectionException | ReflectiveOperationException e) {
            Field field = null;
            try {
                field = this.targetClazz.getDeclaredField(name);
                field.setAccessible(true);
                field.set(result, value);
            }
            catch (ReflectiveOperationException e1) {
                log.warn("dynamic-datasource set {} [{}] failed,please check your config or update {}  to the latest version", new Object[]{this.configName, name, this.configName});
            }
            finally {
                if (field != null && field.isAccessible()) {
                    field.setAccessible(false);
                }
            }
        }
        catch (Exception ee) {
            log.warn("dynamic-datasource set {} [{}] failed,please check your config", new Object[]{this.configName, name, ee});
        }
    }

    public ConfigMergeCreator(String configName, Class<C> configClazz, Class<T> targetClazz) {
        this.configName = configName;
        this.configClazz = configClazz;
        this.targetClazz = targetClazz;
    }
}

