/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vodpro;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.BceServiceException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.vodpro.model.common.Path;
import com.baidubce.services.vodpro.model.request.CreateMediaRequest;
import com.baidubce.services.vodpro.model.request.GetMediaRequest;
import com.baidubce.services.vodpro.model.response.GetVcaResultResponse;
import com.baidubce.services.vodpro.model.response.GetVcrResultResponse;
import com.baidubce.services.vodpro.model.response.MediaResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;

public class VodproClient
extends AbstractBceClient {
    private static HttpResponseHandler[] vodproHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public VodproClient() {
        this(new BceClientConfiguration());
    }

    public VodproClient(BceClientConfiguration config) {
        super(config, vodproHandlers);
    }

    public MediaResponse createMedia(String projectName, String spaceName, String path, String triggerName, String notificationName, String description) {
        CreateMediaRequest request = new CreateMediaRequest();
        request.setPath(new Path(path));
        request.setDescription(description);
        request.setNotificationName(notificationName);
        request.setTriggerName(triggerName);
        return this.createMedia(request, projectName, spaceName);
    }

    public MediaResponse createMedia(CreateMediaRequest request, String projectName, String spaceName) throws BceServiceException {
        Validate.checkStringNotEmpty(projectName, "The parameter projectName should not be null or empty string.");
        Validate.checkStringNotEmpty(spaceName, "The parameter spaceName should not be null or empty string.");
        Validate.checkStringNotEmpty(request.getPath().getMe(), "The parameter path should not be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, "v1", "project", projectName, "space", spaceName, "media");
        String json = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = json.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return this.invokeHttpClient(internalRequest, MediaResponse.class);
    }

    public MediaResponse getMedia(String projectName, String spaceName, String path) {
        GetMediaRequest request = new GetMediaRequest();
        request.setProjectName(projectName);
        request.setSpaceName(spaceName);
        request.setPath(new Path(path));
        return this.getMedia(request);
    }

    private MediaResponse getMedia(GetMediaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, "v1", "project", request.getProjectName(), "space", request.getSpaceName(), "media", request.getPath().getMe());
        return this.invokeHttpClient(internalRequest, MediaResponse.class);
    }

    public GetVcaResultResponse getVcaResult(String projectName, String spaceName, String path, String type) {
        if ("vca".equals(type)) {
            GetMediaRequest request = new GetMediaRequest();
            request.setProjectName(projectName);
            request.setSpaceName(spaceName);
            request.setPath(new Path(path));
            request.setType("vca");
            return this.getVcaResult(request);
        }
        throw new BceClientException("The type is wrong, maybe you should set type to vca");
    }

    private GetVcaResultResponse getVcaResult(GetMediaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, "v1", "project", request.getProjectName(), "space", request.getSpaceName(), "media", request.getPath().getMe());
        internalRequest.addParameter("vca", null);
        return this.invokeHttpClient(internalRequest, GetVcaResultResponse.class);
    }

    public GetVcrResultResponse getVcrResult(String projectName, String spaceName, String path, String type) {
        if ("vcr".equals(type)) {
            GetMediaRequest request = new GetMediaRequest();
            request.setProjectName(projectName);
            request.setSpaceName(spaceName);
            request.setPath(new Path(path));
            request.setType("vcr");
            return this.getVcrResult(request);
        }
        throw new BceClientException("The type is wrong, maybe you should set type to vcr");
    }

    private GetVcrResultResponse getVcrResult(GetMediaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, "v1", "project", request.getProjectName(), "space", request.getSpaceName(), "media", request.getPath().getMe());
        internalRequest.addParameter("vcr", null);
        return this.invokeHttpClient(internalRequest, GetVcrResultResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }
}

