/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.moladb.model.BatchWriteItemResponse;
import com.baidubce.services.moladb.model.WriteRequest;
import com.baidubce.services.moladb.model.transform.BatchWriteUnprocessItemsUnmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class BatchWriteItemResponseUnmarshaller
implements Unmarshaller<BatchWriteItemResponse, InputStream> {
    BatchWriteItemResponse result = null;

    public BatchWriteItemResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (BatchWriteItemResponse)response;
    }

    @Override
    public BatchWriteItemResponse unmarshall(InputStream stream) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(stream);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (root.isNull()) {
            throw new BceClientException("Invalid responseContent:" + streamContents);
        }
        BatchWriteUnprocessItemsUnmarshaller unprocessUnmarshaller = new BatchWriteUnprocessItemsUnmarshaller();
        JsonNode unprocessObj = root.get("unprocessedItems");
        Map<String, List<WriteRequest>> unprocess = null;
        if (unprocessObj != null) {
            unprocess = unprocessUnmarshaller.unmarshall(unprocessObj);
        }
        this.result.setUnprocessedItems(unprocess);
        return this.result;
    }
}

