/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bcc;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.bcc.BccClientConfiguration;
import com.baidubce.services.bcc.model.Billing;
import com.baidubce.services.bcc.model.Reservation;
import com.baidubce.services.bcc.model.image.CreateImageRequest;
import com.baidubce.services.bcc.model.image.CreateImageResponse;
import com.baidubce.services.bcc.model.image.DeleteImageRequest;
import com.baidubce.services.bcc.model.image.GetImageRequest;
import com.baidubce.services.bcc.model.image.GetImageResponse;
import com.baidubce.services.bcc.model.image.ListImagesRequest;
import com.baidubce.services.bcc.model.image.ListImagesResponse;
import com.baidubce.services.bcc.model.instance.BindSecurityGroupRequest;
import com.baidubce.services.bcc.model.instance.CreateInstanceRequest;
import com.baidubce.services.bcc.model.instance.CreateInstanceResponse;
import com.baidubce.services.bcc.model.instance.FpgaCardType;
import com.baidubce.services.bcc.model.instance.GetInstanceRequest;
import com.baidubce.services.bcc.model.instance.GetInstanceResponse;
import com.baidubce.services.bcc.model.instance.GetInstanceVncRequest;
import com.baidubce.services.bcc.model.instance.GetInstanceVncResponse;
import com.baidubce.services.bcc.model.instance.GpuCardType;
import com.baidubce.services.bcc.model.instance.InstanceAction;
import com.baidubce.services.bcc.model.instance.InstanceType;
import com.baidubce.services.bcc.model.instance.ListInstanceSpecsRequest;
import com.baidubce.services.bcc.model.instance.ListInstanceSpecsResponse;
import com.baidubce.services.bcc.model.instance.ListInstancesRequest;
import com.baidubce.services.bcc.model.instance.ListInstancesResponse;
import com.baidubce.services.bcc.model.instance.ModifyInstanceAttributesRequest;
import com.baidubce.services.bcc.model.instance.ModifyInstancePasswordRequest;
import com.baidubce.services.bcc.model.instance.PurchaseReservedInstanceRequeset;
import com.baidubce.services.bcc.model.instance.RebootInstanceRequest;
import com.baidubce.services.bcc.model.instance.RebuildInstanceRequest;
import com.baidubce.services.bcc.model.instance.ReleaseInstanceRequest;
import com.baidubce.services.bcc.model.instance.ResizeInstanceRequest;
import com.baidubce.services.bcc.model.instance.StartInstanceRequest;
import com.baidubce.services.bcc.model.instance.StopInstanceRequest;
import com.baidubce.services.bcc.model.instance.UnbindSecurityGroupRequest;
import com.baidubce.services.bcc.model.securitygroup.CreateSecurityGroupRequest;
import com.baidubce.services.bcc.model.securitygroup.CreateSecurityGroupResponse;
import com.baidubce.services.bcc.model.securitygroup.DeleteSecurityGroupRequest;
import com.baidubce.services.bcc.model.securitygroup.ListSecurityGroupsRequest;
import com.baidubce.services.bcc.model.securitygroup.ListSecurityGroupsResponse;
import com.baidubce.services.bcc.model.securitygroup.SecurityGroupRuleOperateRequest;
import com.baidubce.services.bcc.model.snapshot.CreateSnapshotRequest;
import com.baidubce.services.bcc.model.snapshot.CreateSnapshotResponse;
import com.baidubce.services.bcc.model.snapshot.DeleteSnapshotRequest;
import com.baidubce.services.bcc.model.snapshot.GetSnapshotRequest;
import com.baidubce.services.bcc.model.snapshot.GetSnapshotResponse;
import com.baidubce.services.bcc.model.snapshot.ListSnapshotsRequest;
import com.baidubce.services.bcc.model.snapshot.ListSnapshotsResponse;
import com.baidubce.services.bcc.model.volume.AttachVolumeRequest;
import com.baidubce.services.bcc.model.volume.AttachVolumeResponse;
import com.baidubce.services.bcc.model.volume.CreateVolumeRequest;
import com.baidubce.services.bcc.model.volume.CreateVolumeResponse;
import com.baidubce.services.bcc.model.volume.DetachVolumeRequest;
import com.baidubce.services.bcc.model.volume.GetVolumeRequest;
import com.baidubce.services.bcc.model.volume.GetVolumeResponse;
import com.baidubce.services.bcc.model.volume.ListVolumesRequest;
import com.baidubce.services.bcc.model.volume.ListVolumesResponse;
import com.baidubce.services.bcc.model.volume.PurchaseReservedVolumeRequest;
import com.baidubce.services.bcc.model.volume.ReleaseVolumeRequest;
import com.baidubce.services.bcc.model.volume.ResizeVolumeRequest;
import com.baidubce.services.bcc.model.volume.RollbackVolumeRequest;
import com.baidubce.services.bcc.model.volume.VolumeAction;
import com.baidubce.services.bcc.model.zone.ListZonesResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BccClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(BccClient.class);
    private static final String VERSION = "v2";
    private static final String INSTANCE_PREFIX = "instance";
    private static final String VOLUME_PREFIX = "volume";
    private static final String IMAGE_PREFIX = "image";
    private static final String SECURITYGROUP_PREFIX = "securityGroup";
    private static final String SNAPSHOT_PREFIX = "snapshot";
    private static final String ZONE = "zone";
    private static final HttpResponseHandler[] bcc_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BccClient() {
        this(new BccClientConfiguration());
    }

    public BccClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, bcc_handlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    private String aes128WithFirst16Char(String content, String privateKey) throws GeneralSecurityException {
        byte[] crypted = null;
        SecretKeySpec skey = new SecretKeySpec(privateKey.substring(0, 16).getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, skey);
        crypted = cipher.doFinal(content.getBytes());
        return new String(Hex.encodeHex((byte[])crypted));
    }

    private Billing generateDefaultBilling() {
        Billing billing = new Billing();
        billing.setPaymentTiming("Postpaid");
        return billing;
    }

    private Billing generateDefaultBillingWithReservation() {
        Billing billing = new Billing();
        billing.withReservation(new Reservation().withReservationLength(1));
        return billing;
    }

    public CreateInstanceResponse createInstance(CreateInstanceRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        if (InstanceType.G1.name().equalsIgnoreCase(request.getInstanceType())) {
            Validate.checkIsTrue(GpuCardType.isExists(request.getGpuCard()), "invalid gpgCard parameter");
            Validate.checkIsTrue(request.getCardCount() > 0, "invalid cardCount parameter");
        }
        if (InstanceType.F1.name().equalsIgnoreCase(request.getInstanceType())) {
            Validate.checkIsTrue(FpgaCardType.isExists(request.getFpgaCard()), "invalid fpgaCard parameter");
            Validate.checkIsTrue(request.getCardCount() > 0, "invalid cardCount parameter");
        }
        Validate.checkStringNotEmpty(request.getImageId(), "imageId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, INSTANCE_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        if (!Strings.isNullOrEmpty((String)request.getAdminPass())) {
            BceCredentials credentials = this.config.getCredentials();
            if (internalRequest.getCredentials() != null) {
                credentials = internalRequest.getCredentials();
            }
            try {
                request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
            }
            catch (GeneralSecurityException e) {
                throw new BceClientException("Encryption procedure exception", e);
            }
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateInstanceResponse.class);
    }

    public ListInstancesResponse listInstances() {
        return this.listInstances(new ListInstancesRequest());
    }

    public ListInstancesResponse listInstances(ListInstancesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getInternalIp())) {
            internalRequest.addParameter("internalIp", request.getInternalIp());
        }
        if (!Strings.isNullOrEmpty((String)request.getDedicatedHostId())) {
            internalRequest.addParameter("dedicatedHostId", request.getDedicatedHostId());
        }
        if (!Strings.isNullOrEmpty((String)request.getZoneName())) {
            internalRequest.addParameter("zoneName", request.getZoneName());
        }
        return this.invokeHttpClient(internalRequest, ListInstancesResponse.class);
    }

    public GetInstanceResponse getInstance(String instanceId) {
        return this.getInstance(new GetInstanceRequest().withInstanceId(instanceId));
    }

    public GetInstanceResponse getInstance(GetInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)request.getInstanceId(), (Object)"request instanceId should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX, request.getInstanceId());
        return this.invokeHttpClient(internalRequest, GetInstanceResponse.class);
    }

    public void startInstance(String instanceId) {
        this.startInstance(new StartInstanceRequest().withInstanceId(instanceId));
    }

    public void startInstance(StartInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.start.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void stopInstance(String instanceId) {
        this.stopInstance(new StopInstanceRequest().withInstanceId(instanceId).withForceStop(false));
    }

    public void stopInstance(String instanceId, boolean forceStop) {
        this.stopInstance(new StopInstanceRequest().withInstanceId(instanceId).withForceStop(forceStop));
    }

    public void stopInstance(StopInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.stop.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void rebootInstance(String instanceId) {
        this.rebootInstance(new RebootInstanceRequest().withInstanceId(instanceId).withForceStop(false));
    }

    public void rebootInstance(String instanceId, boolean forceStop) {
        this.rebootInstance(new RebootInstanceRequest().withInstanceId(instanceId).withForceStop(forceStop));
    }

    public void rebootInstance(RebootInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.reboot.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyInstancePassword(String instanceId, String adminPass) throws BceClientException {
        this.modifyInstancePassword(new ModifyInstancePasswordRequest().withInstanceId(instanceId).withAdminPass(adminPass));
    }

    public void modifyInstancePassword(ModifyInstancePasswordRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        Validate.checkStringNotEmpty(request.getAdminPass(), "request adminPass should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.changePass.name(), null);
        BceCredentials credentials = this.config.getCredentials();
        if (internalRequest.getCredentials() != null) {
            credentials = internalRequest.getCredentials();
        }
        try {
            request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
        }
        catch (GeneralSecurityException e) {
            throw new BceClientException("Encryption procedure exception", e);
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifyInstanceAttributes(ModifyInstanceAttributesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        Validate.checkStringNotEmpty(request.getName(), "request name should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.modifyAttribute.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void rebuildInstance(String instanceId, String imageId, String adminPass) throws BceClientException {
        this.rebuildInstance(new RebuildInstanceRequest().withInstanceId(instanceId).withImageId(imageId).withAdminPass(adminPass));
    }

    public void rebuildInstance(RebuildInstanceRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        Validate.checkStringNotEmpty(request.getImageId(), "request imageId should not be empty.");
        Validate.checkStringNotEmpty(request.getAdminPass(), "request adminPass should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.rebuild.name(), null);
        BceCredentials credentials = this.config.getCredentials();
        if (internalRequest.getCredentials() != null) {
            credentials = internalRequest.getCredentials();
        }
        try {
            request.setAdminPass(this.aes128WithFirst16Char(request.getAdminPass(), credentials.getSecretKey()));
        }
        catch (GeneralSecurityException e) {
            throw new BceClientException("Encryption procedure exception", e);
        }
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseInstance(String instanceId) {
        this.releaseInstance(new ReleaseInstanceRequest().withInstanceId(instanceId));
    }

    public void releaseInstance(ReleaseInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, INSTANCE_PREFIX, request.getInstanceId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void resizeInstance(ResizeInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        if (request.getCpuCount() <= 0) {
            throw new IllegalArgumentException("request cpuCount should be positive.");
        }
        if (request.getMemoryCapacityInGB() <= 0) {
            throw new IllegalArgumentException("request memoryCapacityInGB should be positive.");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.resize.name(), null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindInstanceToSecurityGroup(String instanceId, String securityGroupId) {
        this.bindInstanceToSecurityGroup(new BindSecurityGroupRequest().withInstanceId(instanceId).withSecurityGroupId(securityGroupId));
    }

    public void bindInstanceToSecurityGroup(BindSecurityGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), "request securityGroupId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.bind.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unbindInstanceFromSecurityGroup(String instanceId, String securityGroupId) {
        this.unbindInstanceFromSecurityGroup(new UnbindSecurityGroupRequest().withInstanceId(instanceId).withSecurityGroupId(securityGroupId));
    }

    public void unbindInstanceFromSecurityGroup(UnbindSecurityGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), "request securityGroupId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.unbind.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public GetInstanceVncResponse getInstanceVnc(String instanceId) {
        return this.getInstanceVnc(new GetInstanceVncRequest().withInstanceId(instanceId));
    }

    public GetInstanceVncResponse getInstanceVnc(GetInstanceVncRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX, request.getInstanceId(), "vnc");
        return this.invokeHttpClient(internalRequest, GetInstanceVncResponse.class);
    }

    public void purchaseReservedInstance(String instanceId, int reservationLength, String reservationTimeUnit) {
        this.purchaseReservedInstance(new PurchaseReservedInstanceRequeset().withInstanceId(instanceId).withBilling(new Billing().withReservation(new Reservation().withReservationLength(reservationLength).withReservationTimeUnit(reservationTimeUnit))));
    }

    public void purchaseReservedInstance(PurchaseReservedInstanceRequeset request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBillingWithReservation());
        }
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, INSTANCE_PREFIX, request.getInstanceId());
        internalRequest.addParameter(InstanceAction.purchaseReserved.name(), null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    @Deprecated
    public ListInstanceSpecsResponse listInstanceSpecs() {
        return this.listInstanceSpecs(new ListInstanceSpecsRequest());
    }

    @Deprecated
    public ListInstanceSpecsResponse listInstanceSpecs(ListInstanceSpecsRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, INSTANCE_PREFIX, "spec");
        return this.invokeHttpClient(internalRequest, ListInstanceSpecsResponse.class);
    }

    public CreateVolumeResponse createVolume(CreateVolumeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBilling());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VOLUME_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateVolumeResponse.class);
    }

    public ListVolumesResponse listVolumes() {
        return this.listVolumes(new ListVolumesRequest());
    }

    public ListVolumesResponse listVolumes(ListVolumesRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VOLUME_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getInstanceId())) {
            internalRequest.addParameter("instanceId", request.getInstanceId());
        }
        if (!Strings.isNullOrEmpty((String)request.getZoneName())) {
            internalRequest.addParameter("zoneName", request.getZoneName());
        }
        return this.invokeHttpClient(internalRequest, ListVolumesResponse.class);
    }

    public GetVolumeResponse getVolume(String volumeId) {
        return this.getVolume(new GetVolumeRequest().withVolumeId(volumeId));
    }

    public GetVolumeResponse getVolume(GetVolumeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getVolumeId(), "request volumeId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VOLUME_PREFIX, request.getVolumeId());
        return this.invokeHttpClient(internalRequest, GetVolumeResponse.class);
    }

    public AttachVolumeResponse attachVolume(String volumeId, String instanceId) {
        return this.attachVolume(new AttachVolumeRequest().withVolumeId(volumeId).withInstanceId(instanceId));
    }

    public AttachVolumeResponse attachVolume(AttachVolumeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getVolumeId(), "request volumeId should not be empty.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.attach.name(), null);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, AttachVolumeResponse.class);
    }

    public void detachVolume(String volumeId, String instanceId) {
        this.detachVolume(new DetachVolumeRequest().withVolumeId(volumeId).withInstanceId(instanceId));
    }

    public void detachVolume(DetachVolumeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getVolumeId(), "request volumeId should not be empty.");
        Validate.checkStringNotEmpty(request.getInstanceId(), "request instanceId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.detach.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseVolume(String volumeId) {
        this.releaseVolume(new ReleaseVolumeRequest().withVolumeId(volumeId));
    }

    public void releaseVolume(ReleaseVolumeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getVolumeId(), "request volumeId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, VOLUME_PREFIX, request.getVolumeId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void resizeVolume(String volumeId, int newCdsSizeInGB) {
        this.resizeVolume(new ResizeVolumeRequest().withVolumeId(volumeId).withNewCdsSizeInGB(newCdsSizeInGB));
    }

    public void resizeVolume(ResizeVolumeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getVolumeId(), "request volumeId should not be empty.");
        Preconditions.checkState((request.getNewCdsSizeInGB() > 0 ? 1 : 0) != 0, (Object)"request newCdsSizeInGB should greater than 0");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.resize.name(), null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void rollbackVolume(String volumeId, String snapshotId) {
        this.rollbackVolume(new RollbackVolumeRequest().withVolumeId(volumeId).withSnapshotId(snapshotId));
    }

    public void rollbackVolume(RollbackVolumeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getVolumeId(), "request volumeId should not be empty.");
        Validate.checkStringNotEmpty(request.getSnapshotId(), "request snapshotId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.rollback.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void purchaseReservedVolume(String volumeId, int reservationLength, String reservationTimeUnit) {
        this.purchaseReservedVolume(new PurchaseReservedVolumeRequest().withVolumeId(volumeId).withBilling(new Billing().withReservation(new Reservation().withReservationLength(reservationLength).withReservationTimeUnit(reservationTimeUnit))));
    }

    public void purchaseReservedVolume(PurchaseReservedVolumeRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getBilling()) {
            request.setBilling(this.generateDefaultBillingWithReservation());
        }
        Validate.checkStringNotEmpty(request.getVolumeId(), "request volumeId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VOLUME_PREFIX, request.getVolumeId());
        internalRequest.addParameter(VolumeAction.purchaseReserved.name(), null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateImageResponse createImageFromInstance(String imageName, String instanceId) {
        return this.createImage(new CreateImageRequest().withImageName(imageName).withInstanceId(instanceId));
    }

    public CreateImageResponse createImageFromSnapshot(String imageName, String snapshotId) {
        return this.createImage(new CreateImageRequest().withImageName(imageName).withSnapshotId(snapshotId));
    }

    public CreateImageResponse createImage(CreateImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getImageName(), "request imageName should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getInstanceId()) && Strings.isNullOrEmpty((String)request.getSnapshotId())) {
            throw new IllegalArgumentException("request instanceId or snapshotId should not be empty .");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, IMAGE_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateImageResponse.class);
    }

    public ListImagesResponse listImages() {
        return this.listImages(new ListImagesRequest());
    }

    public ListImagesResponse listImages(ListImagesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IMAGE_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getImageType())) {
            internalRequest.addParameter("imageType", request.getImageType());
        }
        return this.invokeHttpClient(internalRequest, ListImagesResponse.class);
    }

    public GetImageResponse getImage(String imageId) {
        return this.getImage(new GetImageRequest().withImageId(imageId));
    }

    public GetImageResponse getImage(GetImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getImageId(), "request imageId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IMAGE_PREFIX, request.getImageId());
        return this.invokeHttpClient(internalRequest, GetImageResponse.class);
    }

    public void deleteImage(String imageId) {
        this.deleteImage(new DeleteImageRequest().withImageId(imageId));
    }

    public void deleteImage(DeleteImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getImageId(), "request imageId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, IMAGE_PREFIX, request.getImageId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateSnapshotResponse createSnapshot(String volumeId, String snapshotName) {
        return this.createSnapshot(new CreateSnapshotRequest().withVolumeId(volumeId).withSnapshotName(snapshotName));
    }

    public CreateSnapshotResponse createSnapshot(String volumeId, String snapshotName, String desc) {
        return this.createSnapshot(new CreateSnapshotRequest().withVolumeId(volumeId).withSnapshotName(snapshotName).withDesc(desc));
    }

    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getVolumeId(), "request volumeId should not be empty.");
        Validate.checkStringNotEmpty(request.getSnapshotName(), "request snapshotName should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SNAPSHOT_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateSnapshotResponse.class);
    }

    public ListSnapshotsResponse listSnapshots(ListSnapshotsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SNAPSHOT_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getVolumeId())) {
            internalRequest.addParameter("volumeId", request.getVolumeId());
        }
        return this.invokeHttpClient(internalRequest, ListSnapshotsResponse.class);
    }

    public GetSnapshotResponse getSnapshot(String snapshotId) {
        return this.getSnapshot(new GetSnapshotRequest().withSnapshotId(snapshotId));
    }

    public GetSnapshotResponse getSnapshot(GetSnapshotRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getSnapshotId(), "request snapshotId should no be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SNAPSHOT_PREFIX, request.getSnapshotId());
        return this.invokeHttpClient(internalRequest, GetSnapshotResponse.class);
    }

    public void deleteSnapshot(String snapshotId) {
        this.deleteSnapshot(new DeleteSnapshotRequest().withSnapshotId(snapshotId));
    }

    public void deleteSnapshot(DeleteSnapshotRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getSnapshotId(), "request snapshotId should no be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, SNAPSHOT_PREFIX, request.getSnapshotId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListSecurityGroupsResponse listSecurityGroups(ListSecurityGroupsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SECURITYGROUP_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getInstanceId())) {
            internalRequest.addParameter("instanceId", request.getInstanceId());
        }
        if (!Strings.isNullOrEmpty((String)request.getVpcId())) {
            internalRequest.addParameter("vpcId", request.getVpcId());
        }
        return this.invokeHttpClient(internalRequest, ListSecurityGroupsResponse.class);
    }

    public CreateSecurityGroupResponse createSecurityGroup(CreateSecurityGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getName(), "request name should not be empty.");
        if (null == request.getRules() || request.getRules().isEmpty()) {
            throw new IllegalArgumentException("request rules should not be empty");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SECURITYGROUP_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateSecurityGroupResponse.class);
    }

    public void authorizeSecurityGroupRule(SecurityGroupRuleOperateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), "securityGroupId should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getRule()) {
            throw new IllegalArgumentException("request rule should not be null");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SECURITYGROUP_PREFIX, request.getSecurityGroupId());
        internalRequest.addParameter("authorizeRule", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void revokeSecurityGroupRule(SecurityGroupRuleOperateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), "securityGroupId should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        if (null == request.getRule()) {
            throw new IllegalArgumentException("request rule should not be null");
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, SECURITYGROUP_PREFIX, request.getSecurityGroupId());
        internalRequest.addParameter("revokeRule", null);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteSecurityGroup(String securityGroupId) {
        this.deleteSecurityGroup(new DeleteSecurityGroupRequest().withSecurityGroupId(securityGroupId));
    }

    public void deleteSecurityGroup(DeleteSecurityGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getSecurityGroupId(), "request securityGroupId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, SECURITYGROUP_PREFIX, request.getSecurityGroupId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListZonesResponse listZones() {
        return this.listZones(new AbstractBceRequest(){

            @Override
            public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
                return null;
            }
        });
    }

    public ListZonesResponse listZones(AbstractBceRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ZONE);
        return this.invokeHttpClient(internalRequest, ListZonesResponse.class);
    }
}

