/*
 * Decompiled with CFR 0.152.
 */
package com.anubhavshukla.p2y.dataobject;

import java.util.SortedMap;
import java.util.TreeMap;

public class DataNode {
    private int tabIndex;
    private SortedMap<String, DataNode> subMap;
    private String value;

    public DataNode(int tabIndex) {
        this.tabIndex = tabIndex;
        this.initSubMap();
    }

    private DataNode() {
        this.initSubMap();
    }

    public static DataNode getInstance() {
        return new DataNode();
    }

    public DataNode getOrPut(String key, int tabIndex) {
        if (this.subMap.containsKey(key)) {
            return (DataNode)this.subMap.get(key);
        }
        DataNode keyNode = new DataNode(tabIndex);
        this.subMap.put(key, keyNode);
        return keyNode;
    }

    private void initSubMap() {
        if (this.subMap == null) {
            this.subMap = new TreeMap<String, DataNode>();
        }
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public SortedMap<String, DataNode> getSubMap() {
        return this.subMap;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public DataNode getNode(String key) {
        return (DataNode)this.subMap.get(key);
    }

    public String toString() {
        return "DataNode{tabIndex=" + this.tabIndex + ", subMap=" + this.subMap + ", value='" + this.value + '\'' + '}';
    }
}

