/*
 * Decompiled with CFR 0.152.
 */
package com.anubhavshukla.p2y.converter;

import com.anubhavshukla.p2y.converter.CommentIdentifier;
import com.anubhavshukla.p2y.dataobject.DataNode;
import com.anubhavshukla.p2y.exception.FileNotFoundException;
import com.anubhavshukla.p2y.exception.InvalidRequestException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertiesToDataNodeConverter {
    private static final Logger LOGGER = Logger.getLogger(PropertiesToDataNodeConverter.class.getName());
    private static final char PROPERTY_SEPARATOR = '=';
    private final CommentIdentifier commentIdentifier = new CommentIdentifier();

    public DataNode toDataNode(String filePath) {
        File propertiesFile = new File(filePath);
        if (!propertiesFile.exists()) {
            LOGGER.log(Level.SEVERE, "File does not exist: " + filePath);
            throw new FileNotFoundException("File not found.");
        }
        if (propertiesFile.isDirectory()) {
            return this.directoryToDataNode(propertiesFile);
        }
        return this.fileToDataNode(propertiesFile);
    }

    public DataNode directoryToDataNode(File propertiesFolder) {
        if (propertiesFolder == null || !propertiesFolder.exists()) {
            LOGGER.log(Level.SEVERE, "File does not exist.");
            throw new FileNotFoundException("File not found.");
        }
        if (propertiesFolder.isFile()) {
            LOGGER.log(Level.SEVERE, "Given file path is not a directory: " + propertiesFolder.getName());
            throw new InvalidRequestException("Not a directory.");
        }
        LinkedList<String> propertiesList = new LinkedList<String>();
        Arrays.stream((Object[])Objects.requireNonNull(propertiesFolder.list())).filter(s -> s.endsWith(".properties")).forEach(file -> propertiesList.addAll(this.fileToPropertiesList(this.getPropertiesFile(propertiesFolder, (String)file))));
        return this.propertiesListToDataNode(propertiesList);
    }

    private File getPropertiesFile(File propertiesFile, String file) {
        return new File(propertiesFile.getAbsolutePath() + File.separator + file);
    }

    public DataNode fileToDataNode(File propertiesFile) {
        if (propertiesFile == null || !propertiesFile.exists()) {
            LOGGER.log(Level.SEVERE, "File does not exist.");
            throw new FileNotFoundException("File not found.");
        }
        if (propertiesFile.isDirectory()) {
            LOGGER.log(Level.SEVERE, "Given file path is not a file.");
            throw new InvalidRequestException("Not a directory.");
        }
        return this.propertiesListToDataNode(this.fileToPropertiesList(propertiesFile));
    }

    private List<String> fileToPropertiesList(File propertiesFile) {
        LinkedList<String> propertiesList = new LinkedList<String>();
        try {
            BufferedReader b = new BufferedReader(new FileReader(propertiesFile));
            String readLine = "";
            while ((readLine = b.readLine()) != null) {
                if (this.commentIdentifier.isComment(readLine)) {
                    LOGGER.log(Level.FINE, "Ignoring comment line: " + readLine);
                    continue;
                }
                propertiesList.add(readLine);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error parsing file", e);
        }
        return propertiesList;
    }

    private DataNode propertiesListToDataNode(List<String> propertiesList) {
        LOGGER.fine("Converting properties list to DataNode: " + propertiesList);
        DataNode rootNode = DataNode.getInstance();
        propertiesList.stream().filter(line -> this.isValidPropertyLine((String)line)).forEach(line -> this.processProperty((String)line, rootNode));
        LOGGER.fine("Generated DataNode: " + rootNode);
        return rootNode;
    }

    private boolean isValidPropertyLine(String line) {
        return !line.trim().equals("") && line.contains("=");
    }

    private DataNode processProperty(String propertyLine, DataNode rootNode) {
        LOGGER.fine("Processing property string: " + propertyLine);
        int indexOfPropertySeparator = propertyLine.indexOf(61);
        String key = propertyLine.substring(0, indexOfPropertySeparator);
        String value = propertyLine.substring(indexOfPropertySeparator + 1);
        return this.processProperty(key, value, rootNode);
    }

    private DataNode processProperty(String key, String value, DataNode dataNode) {
        String[] keyParts = key.split("\\.");
        DataNode currentDataNode = dataNode;
        for (int i = 0; i < keyParts.length; ++i) {
            currentDataNode = currentDataNode.getOrPut(keyParts[i], i);
        }
        currentDataNode.setValue(value);
        return dataNode;
    }
}

