/*
 * Decompiled with CFR 0.152.
 */
package com.anubhavshukla.p2y.converter;

import com.anubhavshukla.p2y.dataobject.DataNode;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class DataNodeToYamlConverter {
    private static final Logger LOGGER = Logger.getLogger(DataNodeToYamlConverter.class.getName());
    private static final int SPACING_PER_TAB_INDEX = 2;
    private static final String SINGLE_SPACE = " ";
    private static final String COLON = ":";

    public String toYamlString(DataNode startNode) {
        return this.parseDataNode(startNode).toString();
    }

    private StringBuilder parseDataNode(DataNode startNode) {
        LOGGER.log(Level.FINE, "Received DataNode for conversion to YAML: " + startNode);
        StringBuilder stringBuffer = new StringBuilder();
        startNode.getSubMap().forEach((s, dataNode) -> {
            stringBuffer.append(this.getSpaceString(dataNode.getTabIndex())).append((String)s).append(COLON);
            if (dataNode.getValue() != null) {
                stringBuffer.append(SINGLE_SPACE).append(dataNode.getValue()).append(System.lineSeparator());
            } else {
                stringBuffer.append(System.lineSeparator());
            }
            stringBuffer.append((CharSequence)this.parseDataNode((DataNode)dataNode));
        });
        return stringBuffer;
    }

    private StringBuffer getSpaceString(int tabIndex) {
        StringBuffer stringBuffer = new StringBuffer();
        IntStream.range(0, tabIndex * 2).forEach(value -> stringBuffer.append(SINGLE_SPACE));
        return stringBuffer;
    }
}

