/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util;

import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.AttributeExtractTask;
import com.alibaba.boot.nacos.config.util.BinderUtils;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class NacosConfigPropertiesUtils {
    private static final String PROPERTIES_PREFIX = "nacos";
    private static final Logger logger;
    private static Set<String> OBJ_FIELD_NAME;

    public static NacosConfigProperties buildNacosConfigProperties(ConfigurableEnvironment environment) {
        NacosConfigProperties bean = new NacosConfigProperties();
        AttributeExtractTask task = new AttributeExtractTask(PROPERTIES_PREFIX, environment);
        try {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)task.call());
            BinderUtils.bind(bean, "nacos.config", properties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.info("nacosConfigProperties : {}", (Object)bean);
        return bean;
    }

    static {
        Field[] fields;
        logger = LoggerFactory.getLogger(NacosConfigPropertiesUtils.class);
        OBJ_FIELD_NAME = new HashSet<String>();
        for (Field field : fields = NacosConfigProperties.class.getDeclaredFields()) {
            OBJ_FIELD_NAME.add(field.getName());
        }
    }
}

