/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.autoconfigure;

import com.alibaba.boot.nacos.config.autoconfigure.NacosBootConfigException;
import com.alibaba.boot.nacos.config.autoconfigure.NacosConfigEnvironmentProcessor;
import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.Function;
import com.alibaba.boot.nacos.config.util.NacosConfigPropertiesUtils;
import com.alibaba.boot.nacos.config.util.NacosConfigUtils;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.factory.CacheableEventPublishingNacosServiceFactory;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class NacosConfigApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final Logger logger = LoggerFactory.getLogger(NacosConfigApplicationInitializer.class);
    private ConfigurableEnvironment environment;
    private final NacosConfigEnvironmentProcessor processor;
    private NacosConfigProperties nacosConfigProperties;

    public NacosConfigApplicationInitializer(NacosConfigEnvironmentProcessor configEnvironmentProcessor) {
        this.processor = configEnvironmentProcessor;
    }

    public void initialize(ConfigurableApplicationContext context) {
        final CacheableEventPublishingNacosServiceFactory singleton = CacheableEventPublishingNacosServiceFactory.getSingleton();
        singleton.setApplicationContext((ApplicationContext)context);
        this.environment = context.getEnvironment();
        this.nacosConfigProperties = NacosConfigPropertiesUtils.buildNacosConfigProperties(this.environment);
        this.processor.publishDeferService((ApplicationContext)context);
        if (!this.enable()) {
            this.logger.info("[Nacos Config Boot] : The preload configuration is not enabled");
        } else {
            Function<Properties, ConfigService> builder = new Function<Properties, ConfigService>(){

                @Override
                public ConfigService apply(Properties input) {
                    try {
                        return singleton.createConfigService(input);
                    }
                    catch (NacosException e) {
                        throw new NacosBootConfigException("ConfigService can't be created with properties : " + input, e);
                    }
                }
            };
            NacosConfigUtils configUtils = new NacosConfigUtils(this.nacosConfigProperties, this.environment, builder);
            if (this.processor.enable()) {
                configUtils.addListenerIfAutoRefreshed(this.processor.getDeferPropertySources());
            } else {
                configUtils.loadConfig();
                configUtils.addListenerIfAutoRefreshed();
            }
        }
    }

    private boolean enable() {
        return this.nacosConfigProperties.getBootstrap().isEnable();
    }
}

