/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.sms.utils.huyi;

import com.ailikes.common.utils.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuyiRestSDK {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String SERVER_URL;
    private String ACCOUNT_NAME;
    private String ACCOUNT_PASSWORD;

    public void init(String serverUrl) {
        if (StringUtils.isEmpty((String)serverUrl)) {
            this.logger.error("\u521d\u59cb\u5316\u5f02\u5e38:serverUrl\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (StringUtils.isEmpty((String)serverUrl) ? " \u670d\u52a1\u5668\u5730\u5740 " : "") + "\u4e3a\u7a7a");
        }
        this.SERVER_URL = serverUrl;
    }

    public void setAccount(String accountName, String accountPassword) {
        if (StringUtils.isEmpty((String)accountName) || StringUtils.isEmpty((String)accountPassword)) {
            this.logger.error("\u521d\u59cb\u5316\u5f02\u5e38:accountName\u6216accountPassword\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (StringUtils.isEmpty((String)accountName) ? " \u5e10\u53f7" : "") + (StringUtils.isEmpty((String)accountPassword) ? " \u5bc6\u7801 " : "") + "\u4e3a\u7a7a");
        }
        this.ACCOUNT_NAME = accountName;
        this.ACCOUNT_PASSWORD = accountPassword;
    }

    public Map<String, Object> sendMsg(String mobile, String content) {
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (StringUtils.isEmpty((String)mobile) || StringUtils.isEmpty((String)content)) {
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (StringUtils.isEmpty((String)mobile) ? " \u624b\u673a\u53f7\u7801 " : "") + (StringUtils.isEmpty((String)content) ? " \u5167\u5bb9 " : "") + "\u4e3a\u7a7a");
        }
        int status = 0;
        try {
            HttpPost httppost = new HttpPost(this.SERVER_URL + "?method=Submit");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("account", this.ACCOUNT_NAME));
            params.add(new BasicNameValuePair("password", this.ACCOUNT_PASSWORD));
            params.add(new BasicNameValuePair("mobile", mobile));
            params.add(new BasicNameValuePair("content", content));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "GBK");
            httppost.setEntity((HttpEntity)entity);
            HttpResponse httpresponse = httpClient.execute((HttpUriRequest)httppost);
            status = httpresponse.getStatusLine().getStatusCode();
            if (status == 200) {
                HttpEntity responseEntity = httpresponse.getEntity();
                String body = EntityUtils.toString((HttpEntity)responseEntity);
                if (responseEntity != null) {
                    responseEntity.consumeContent();
                }
                Document doc = DocumentHelper.parseText((String)body);
                Element root = doc.getRootElement();
                String code = root.elementText("code");
                String msg = root.elementText("msg");
                String smsid = root.elementText("smsid");
                resultData.put("code", code);
                resultData.put("msg", msg);
                resultData.put("smsid", smsid);
                if ("2".equals(code)) {
                    this.logger.info("\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
                } else {
                    this.logger.error(msg);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            return this.getMyError("172001", "\u7f51\u7edc\u9519\u8befHttps\u8bf7\u6c42\u8fd4\u56de\u7801\uff1a" + status);
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.getMyError("172001", "\u7f51\u7edc\u9519\u8befHttps\u8bf7\u6c42\u8fd4\u56de\u7801\uff1a" + status);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return this.getMyError("18000", "\u6587\u4ef6\u89e3\u6790\u9519\u8befHttps\u8bf7\u6c42\u8fd4\u56de\u7801\uff1a" + status);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            return this.getMyError("172002", "\u65e0\u8fd4\u56de");
        }
        return resultData;
    }

    public Map<String, Object> getReply() {
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        DefaultHttpClient httpClient = new DefaultHttpClient();
        int status = 0;
        try {
            HttpPost httppost = new HttpPost(this.SERVER_URL + "?method=GetReply");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("account", this.ACCOUNT_NAME));
            params.add(new BasicNameValuePair("password", this.ACCOUNT_PASSWORD));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "GBK");
            httppost.setEntity((HttpEntity)entity);
            HttpResponse httpresponse = httpClient.execute((HttpUriRequest)httppost);
            status = httpresponse.getStatusLine().getStatusCode();
            if (status == 200) {
                HttpEntity responseEntity = httpresponse.getEntity();
                String body = EntityUtils.toString((HttpEntity)responseEntity);
                if (responseEntity != null) {
                    responseEntity.consumeContent();
                }
                Document doc = DocumentHelper.parseText((String)body);
                Element root = doc.getRootElement();
                String code = root.elementText("code");
                String msg = root.elementText("msg");
                String smsid = root.elementText("smsid");
                resultData.put("code", code);
                resultData.put("msg", msg);
                resultData.put("smsid", smsid);
                if ("2".equals(code)) {
                    this.logger.info("\u77ed\u4fe1\u83b7\u53d6\u6210\u529f");
                } else {
                    this.logger.error(msg);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            return this.getMyError("172001", "\u7f51\u7edc\u9519\u8befHttps\u8bf7\u6c42\u8fd4\u56de\u7801\uff1a" + status);
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.getMyError("172001", "\u7f51\u7edc\u9519\u8befHttps\u8bf7\u6c42\u8fd4\u56de\u7801\uff1a" + status);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return this.getMyError("18000", "\u6587\u4ef6\u89e3\u6790\u9519\u8befHttps\u8bf7\u6c42\u8fd4\u56de\u7801\uff1a" + status);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            return this.getMyError("172002", "\u65e0\u8fd4\u56de");
        }
        return resultData;
    }

    private HashMap<String, Object> getMyError(String code, String msg) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("code", code);
        hashMap.put("msg", msg);
        return hashMap;
    }
}

