/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.hibernate.mvc.dao.impl;

import com.ailikes.common.hibernate.mvc.dao.ISqlDao;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="sqlDao")
public class SqlDaoImpl
implements ISqlDao {
    @Autowired
    @Qualifier(value="sessionFactory")
    private SessionFactory sessionFactory;

    protected final Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public void setParameters(Query query, Object[] params) {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i, params[i]);
            }
        }
    }

    private void setAliasParameter(Query query, Map<String, Object> alias) {
        if (alias != null) {
            Set<String> keys = alias.keySet();
            for (String key : keys) {
                Object val = alias.get(key);
                if (val instanceof Collection) {
                    query.setParameterList(key, (Collection)val);
                    continue;
                }
                query.setParameter(key, val);
            }
        }
    }

    @Override
    public void executeSql(String sql, Object ... params) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setParameters((Query)query, params);
        query.executeUpdate();
    }

    @Override
    public void executeAliasSql(String sql, Map<String, Object> alias) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setAliasParameter((Query)query, alias);
        query.executeUpdate();
    }

    @Override
    public Integer countBySql(String sql, Object ... params) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setParameters((Query)query, params);
        BigInteger uniqueResult = (BigInteger)query.uniqueResult();
        return uniqueResult.intValue();
    }

    @Override
    public Integer countByAliasSql(String sql, Map<String, Object> alias) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setAliasParameter((Query)query, alias);
        BigInteger uniqueResult = (BigInteger)query.uniqueResult();
        return uniqueResult.intValue();
    }

    @Override
    public List<Map<String, Object>> listBySql(String sql, Object ... params) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        this.setParameters((Query)query, params);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listPageBySql(String sql, int page, int rows, Object ... params) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        this.setParameters((Query)query, params);
        query.setMaxResults(rows);
        query.setFirstResult((page - 1) * rows);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listByAliasSql(String sql, Map<String, Object> alias) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        this.setAliasParameter((Query)query, alias);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> listPageByAliasSql(String sql, int page, int rows, Map<String, Object> alias) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        this.setAliasParameter((Query)query, alias);
        query.setMaxResults(rows);
        query.setFirstResult((page - 1) * rows);
        return query.list();
    }

    @Override
    public <T> List<T> listEntityBySql(String sql, Class<T> entityClass, Object ... params) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setParameters((Query)query, params);
        query.addEntity(entityClass);
        return query.list();
    }

    @Override
    public <T> List<T> listPageEntityBySql(String sql, int page, int rows, Class<T> entityClass, Object ... params) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setParameters((Query)query, params);
        query.addEntity(entityClass);
        query.setMaxResults(rows);
        query.setFirstResult((page - 1) * rows);
        return query.list();
    }

    @Override
    public <T> List<T> listPageEntityByAliasSql(String sql, int page, int rows, Class<T> entityClass, Map<String, Object> alias) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setAliasParameter((Query)query, alias);
        query.addEntity(entityClass);
        query.setMaxResults(rows);
        query.setFirstResult((page - 1) * rows);
        return query.list();
    }

    @Override
    public <T> List<T> listEntityByAliasSql(String sql, Class<T> entityClass, Map<String, Object> alias) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.setAliasParameter((Query)query, alias);
        query.addEntity(entityClass);
        return query.list();
    }
}

