/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.hibernate.mvc.entity;

import com.ailikes.common.mvc.entity.AbstractEntity;
import com.ailikes.common.mvc.entity.tree.TreeNode;
import com.ailikes.common.utils.StringUtils;
import java.util.ArrayList;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;

@MappedSuperclass
public abstract class TreeEntity
extends AbstractEntity<String>
implements TreeNode<String> {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String parentId;
    private String parentIds;
    private Boolean expanded = Boolean.FALSE;
    private Boolean loaded = Boolean.TRUE;

    @Id
    @GeneratedValue(generator="paymentableGenerator")
    @GenericGenerator(name="paymentableGenerator", strategy="uuid")
    @Column(name="id", nullable=false, length=32)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name="name", nullable=true, length=250)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="parent_id", nullable=true, length=32)
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Column(name="parent_ids", nullable=true, length=32)
    public String getParentIds() {
        return this.parentIds;
    }

    public void setParentIds(String parentIds) {
        this.parentIds = parentIds;
    }

    @Transient
    public boolean isRoot() {
        return this.getParentId() == null || this.getParentId().equals("0") || this.getParentId().equals("");
    }

    @Transient
    public abstract boolean isHasChildren();

    public abstract void setHasChildren(boolean var1);

    @Transient
    public Long getLevel() {
        if (this.parentIds == null) {
            return 0L;
        }
        String[] parentIdArr = this.parentIds.split("/");
        ArrayList<String> idsList = new ArrayList<String>();
        for (String id : parentIdArr) {
            if (StringUtils.isEmpty((String)id)) continue;
            idsList.add(id);
        }
        return idsList.size();
    }

    @Transient
    public Boolean isLeaf() {
        if (this.isHasChildren()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String makeSelfAsNewParentIds() {
        if (StringUtils.isEmpty((String)this.getParentIds())) {
            return this.getId() + this.getSeparator();
        }
        return this.getParentIds() + this.getId() + this.getSeparator();
    }

    @Transient
    public String getSeparator() {
        return "/";
    }

    public void setExpanded(Boolean expanded) {
        this.expanded = expanded;
    }

    @Transient
    public Boolean getExpanded() {
        return this.expanded;
    }

    public void setLoaded(Boolean loaded) {
        this.loaded = loaded;
    }

    @Transient
    public Boolean getLoaded() {
        return this.loaded;
    }
}

