/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.api.request;

import com.ailikes.common.form.base.api.exception.BusinessException;
import com.ailikes.common.form.base.api.request.RequestHead;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RequestParam {
    private RequestHead head;
    private Map<String, Object> params = new HashMap<String, Object>();

    public void addParam(String key, Object val) {
        this.params.put(key, val);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public Object getParam(String key) {
        return this.params.get(key);
    }

    public String getStringParam(String key) {
        if (!this.params.containsKey(key)) {
            return "";
        }
        return (String)this.params.get(key);
    }

    public String getRQString(String key, String errorMsg) {
        if (this.isParamEmpty(key)) {
            throw new BusinessException(errorMsg + "[" + key + "]");
        }
        return (String)this.params.get(key);
    }

    public Object getRQObject(String key, String errorMsg) {
        if (this.isParamEmpty(key)) {
            throw new BusinessException(errorMsg + "[" + key + "]");
        }
        return this.params.get(key);
    }

    public BigDecimal getBigDecimal(String key) {
        Object val = this.params.get(key);
        if (val instanceof String) {
            BigDecimal bd = new BigDecimal((String)val);
            return bd;
        }
        return (BigDecimal)this.params.get(key);
    }

    public Date getRQDate(String key, String errorMsg) {
        if (this.isParamEmpty(key)) {
            throw new BusinessException(errorMsg + "[" + key + "]");
        }
        return this.getDate(key);
    }

    public Date getDate(String key) {
        SimpleDateFormat dateFormat;
        Object date = this.params.get(key);
        if (date instanceof Date) {
            return (Date)date;
        }
        String dateStr = (String)date;
        if (dateStr.indexOf("/") != -1) {
            dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        } else if (dateStr.indexOf("-") != -1) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        } else {
            return null;
        }
        try {
            Date date1 = null;
            try {
                date1 = dateFormat.parse(dateStr);
            }
            catch (Exception e) {
                date1 = dateFormat.parse(dateStr);
            }
            return date1;
        }
        catch (Exception e) {
            throw new BusinessException(key + "\u65e5\u671f\u89e3\u6790\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
    }

    public boolean isParamEmpty(String key) {
        if (!this.params.containsKey(key)) {
            return true;
        }
        Object o = this.params.get(key);
        if (o == null) {
            return true;
        }
        return o instanceof String ? ((String)o).trim().length() == 0 : (o instanceof Collection ? ((Collection)o).size() == 0 : (o.getClass().isArray() ? ((Object[])o).length == 0 : o instanceof Map && ((Map)o).size() == 0));
    }

    public RequestHead getHead() {
        return this.head;
    }

    public void setHead(RequestHead head) {
        this.head = head;
    }
}

