/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.api.constant;

import com.ailikes.common.form.base.api.exception.BusinessException;
import java.util.Arrays;

public enum ColumnType {
    VARCHAR("varchar", "\u5b57\u7b26\u4e32", new String[]{"varchar", "varchar2", "char", "tinyblob", "tinytext"}),
    CLOB("clob", "\u5927\u6587\u672c", new String[]{"text", "clob", "blob", "mediumblob", "mediumtext", "longblob", "longtext"}),
    NUMBER("number", "\u6570\u5b57\u578b", new String[]{"tinyint", "number", "smallint", "mediumint", "int", "integer", "bigint", "float", "double", "decimal", "numeric"}),
    DATE("date", "\u65e5\u671f\u578b", new String[]{"date", "time", "year", "datetime", "timestamp"});

    private String key;
    private String desc;
    private String[] supports;

    private ColumnType(String key, String desc, String[] supports) {
        this.key = key;
        this.desc = desc;
        this.supports = supports;
    }

    public String getKey() {
        return this.key;
    }

    public String getDesc() {
        return this.desc;
    }

    public String[] getSupports() {
        return this.supports;
    }

    public boolean equalsWithKey(String key) {
        return this.key.equals(key);
    }

    public static ColumnType getByKey(String key) {
        for (ColumnType type : ColumnType.values()) {
            if (!type.getKey().equals(key)) continue;
            return type;
        }
        throw new BusinessException(String.format("\u627e\u4e0d\u5230key\u4e3a[%s]\u7684\u5b57\u6bb5\u7c7b\u578b", key));
    }

    public static ColumnType getByDbDataType(String dbDataType) {
        for (ColumnType type : ColumnType.values()) {
            for (String support : Arrays.asList(type.supports)) {
                if (!dbDataType.toLowerCase().contains(support.toLowerCase())) continue;
                return type;
            }
        }
        throw new BusinessException(String.format("\u6570\u636e\u5e93\u7c7b\u578b[%s]\u8f6c\u6362\u4e0d\u4e86\u7cfb\u7edf\u652f\u6301\u7684\u7c7b\u578b", dbDataType));
    }
}

