/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.email.disruptor;

import com.ailikes.common.email.data.EmailResult;
import com.ailikes.common.email.disruptor.EmailDao;
import com.ailikes.common.email.disruptor.EmailData;
import com.ailikes.common.email.disruptor.EmailEvent;
import com.ailikes.common.email.disruptor.EmailEventFactory;
import com.ailikes.common.email.disruptor.EmailEventProducer;
import com.ailikes.common.email.disruptor.EmailHandler;
import com.ailikes.common.email.disruptor.EmailHandlerCallBack;
import com.ailikes.common.email.disruptor.MailSenderFactory;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.mail.internet.MimeMessage;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.mail.javamail.JavaMailSender;

public class EmailHelper {
    private int handlerCount = 1;
    private int bufferSize = 1024;
    private Disruptor<EmailEvent> disruptor;
    private EmailEventProducer emailEventProducer;
    private EmailDao emailDao = null;

    public EmailHelper() {
    }

    public EmailHelper(int handlerCount, int bufferSize) {
        this.handlerCount = handlerCount;
        this.bufferSize = bufferSize;
    }

    @PostConstruct
    private void start() {
        ExecutorService executor = Executors.newCachedThreadPool();
        EmailEventFactory factory = new EmailEventFactory();
        this.disruptor = new Disruptor((EventFactory)factory, this.bufferSize, (Executor)executor, ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        ArrayList<EmailHandler> emailHandlers = new ArrayList<EmailHandler>();
        for (int i = 0; i < this.handlerCount; ++i) {
            emailHandlers.add(new EmailHandler(this.emailDao));
        }
        this.disruptor.handleExceptionsWith((ExceptionHandler)new IgnoreExceptionHandler());
        this.disruptor.handleEventsWithWorkerPool((WorkHandler[])emailHandlers.toArray(new EmailHandler[emailHandlers.size()]));
        this.disruptor.start();
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        this.emailEventProducer = new EmailEventProducer((RingBuffer<EmailEvent>)ringBuffer, this.emailDao);
    }

    public void shutdown() {
        this.doHalt();
    }

    private void doHalt() {
        this.disruptor.halt();
    }

    public String sendAsync(String eventId, MimeMessage message, MailProperties mailProperties) {
        return this.emailEventProducer.send(eventId, message, mailProperties);
    }

    public String sendAsync(String eventId, MimeMessage message, MailProperties mailProperties, EmailHandlerCallBack callBack) {
        return this.emailEventProducer.send(eventId, message, mailProperties, callBack);
    }

    public EmailResult sendSync(String eventId, MimeMessage message, MailProperties mailProperties) {
        EmailData emailData = new EmailData();
        emailData.setMimeMessage(message);
        emailData.setMailProperties(mailProperties);
        EmailEvent emailEvent = new EmailEvent();
        emailEvent.setId(eventId);
        emailEvent.setEmailData(emailData);
        EmailResult emailResult = EmailResult.success("\u53d1\u9001\u6210\u529f");
        try {
            MailSenderFactory.build(mailProperties).send(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            emailResult = EmailResult.fail("\u53d1\u9001\u5931\u8d25");
        }
        if (this.emailDao != null) {
            this.emailDao.doResult(eventId, emailData, emailResult);
        }
        return emailResult;
    }

    public MimeMessage createMimeMessage(MailProperties mailProperties) {
        JavaMailSender javaMailSender = MailSenderFactory.build(mailProperties);
        return javaMailSender.createMimeMessage();
    }

    public int getHandlerCount() {
        return this.handlerCount;
    }

    public void setHandlerCount(int handlerCount) {
        this.handlerCount = handlerCount;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public EmailDao getEmailDao() {
        return this.emailDao;
    }

    public void setEmailDao(EmailDao emailDao) {
        this.emailDao = emailDao;
    }
}

