/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.email.disruptor;

import com.ailikes.common.email.disruptor.EmailDao;
import com.ailikes.common.email.disruptor.EmailData;
import com.ailikes.common.email.disruptor.EmailEvent;
import com.ailikes.common.email.disruptor.EmailHandlerCallBack;
import com.lmax.disruptor.RingBuffer;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mail.MailProperties;

public class EmailEventProducer {
    private static Logger logger = LoggerFactory.getLogger(EmailEventProducer.class);
    private final RingBuffer<EmailEvent> ringBuffer;
    private EmailDao emailDao;

    public EmailEventProducer(RingBuffer<EmailEvent> ringBuffer, EmailDao emailDao) {
        this.ringBuffer = ringBuffer;
        this.emailDao = emailDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String send(String eventId, EmailData emailData, EmailHandlerCallBack callBack) {
        long sequence = this.ringBuffer.next();
        try {
            EmailEvent emailEvent = (EmailEvent)this.ringBuffer.get(sequence);
            emailEvent.setId(eventId);
            emailEvent.setEmailData(emailData);
            emailEvent.setHandlerCallBack(callBack);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
        return eventId;
    }

    public String send(String eventId, MimeMessage message, MailProperties mailProperties) {
        return this.send(eventId, message, mailProperties, null);
    }

    public String send(String eventId, MimeMessage message, MailProperties mailProperties, EmailHandlerCallBack callBack) {
        EmailData emailData = new EmailData();
        emailData.setMailProperties(mailProperties);
        emailData.setMimeMessage(message);
        return this.send(eventId, emailData, callBack);
    }
}

