/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.email.disruptor;

import com.ailikes.common.utils.SpringContextHolder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public final class MailSenderFactory {
    public static JavaMailSender build(MailProperties mailProperties) {
        if (mailProperties == null) {
            return (JavaMailSender)SpringContextHolder.getBean(JavaMailSender.class);
        }
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        MailSenderCondition.build(sender, mailProperties);
        return null;
    }

    public static class MailSenderCondition {
        public static void build(JavaMailSenderImpl sender, MailProperties mailPropertie) {
            new MailSenderCondition(sender, mailPropertie);
        }

        public MailSenderCondition(JavaMailSenderImpl sender, MailProperties mailProperties) {
            this.applyProperties(sender, mailProperties);
        }

        private void applyProperties(JavaMailSenderImpl sender, MailProperties mailProperties) {
            PropertyMapper map = PropertyMapper.get();
            map.from(() -> ((MailProperties)mailProperties).getHost()).to(arg_0 -> ((JavaMailSenderImpl)sender).setHost(arg_0));
            map.from(() -> ((MailProperties)mailProperties).getPort()).whenNonNull().to(arg_0 -> ((JavaMailSenderImpl)sender).setPort(arg_0));
            map.from(() -> ((MailProperties)mailProperties).getUsername()).to(arg_0 -> ((JavaMailSenderImpl)sender).setUsername(arg_0));
            map.from(() -> ((MailProperties)mailProperties).getPassword()).to(arg_0 -> ((JavaMailSenderImpl)sender).setPassword(arg_0));
            map.from(() -> ((MailProperties)mailProperties).getProtocol()).to(arg_0 -> ((JavaMailSenderImpl)sender).setProtocol(arg_0));
            map.from(() -> ((MailProperties)mailProperties).getDefaultEncoding()).whenNonNull().as(Charset::name).to(arg_0 -> ((JavaMailSenderImpl)sender).setDefaultEncoding(arg_0));
            map.from(() -> ((MailProperties)mailProperties).getProperties()).whenNot(Map::isEmpty).as(this::asProperties).to(arg_0 -> ((JavaMailSenderImpl)sender).setJavaMailProperties(arg_0));
        }

        private Properties asProperties(Map<String, String> source) {
            Properties properties = new Properties();
            properties.putAll(source);
            return properties;
        }
    }
}

