/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.exception.base;

import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;

public class ServiceException
extends RuntimeException {
    private String errorCode;
    private String userTip;
    private String moduleName;

    public ServiceException(String moduleName, String errorCode, String userTip) {
        super(userTip);
        this.errorCode = errorCode;
        this.moduleName = moduleName;
        this.userTip = userTip;
    }

    public ServiceException(String moduleName, AbstractExceptionEnum exception) {
        super(exception.getUserTip());
        this.moduleName = moduleName;
        this.errorCode = exception.getErrorCode();
        this.userTip = exception.getUserTip();
    }

    public ServiceException(AbstractExceptionEnum exception) {
        super(exception.getUserTip());
        this.moduleName = "kernel-a-rule";
        this.errorCode = exception.getErrorCode();
        this.userTip = exception.getUserTip();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getUserTip() {
        return this.userTip;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setUserTip(String userTip) {
        this.userTip = userTip;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public String toString() {
        return "ServiceException(errorCode=" + this.getErrorCode() + ", userTip=" + this.getUserTip() + ", moduleName=" + this.getModuleName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceException)) {
            return false;
        }
        ServiceException other = (ServiceException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$userTip = this.getUserTip();
        String other$userTip = other.getUserTip();
        if (this$userTip == null ? other$userTip != null : !this$userTip.equals(other$userTip)) {
            return false;
        }
        String this$moduleName = this.getModuleName();
        String other$moduleName = other.getModuleName();
        return !(this$moduleName == null ? other$moduleName != null : !this$moduleName.equals(other$moduleName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $userTip = this.getUserTip();
        result = result * 59 + ($userTip == null ? 43 : $userTip.hashCode());
        String $moduleName = this.getModuleName();
        result = result * 59 + ($moduleName == null ? 43 : $moduleName.hashCode());
        return result;
    }
}

