/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.zuul;

import com.alibaba.csp.sentinel.adapter.zuul.fallback.DefaultRequestOriginParser;
import com.alibaba.csp.sentinel.adapter.zuul.fallback.DefaultUrlCleaner;
import com.alibaba.csp.sentinel.adapter.zuul.fallback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.zuul.fallback.UrlCleaner;
import com.alibaba.csp.sentinel.adapter.zuul.filters.SentinelErrorFilter;
import com.alibaba.csp.sentinel.adapter.zuul.filters.SentinelPostFilter;
import com.alibaba.csp.sentinel.adapter.zuul.filters.SentinelPreFilter;
import com.alibaba.csp.sentinel.adapter.zuul.properties.SentinelZuulProperties;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.netflix.zuul.ZuulFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.alibaba.sentinel.zuul.handler.FallBackProviderHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(prefix="spring.cloud.sentinel.zuul", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SentinelZuulAutoConfiguration {
    @Autowired
    private Environment environment;
    public static final String PREFIX = "spring.cloud.sentinel.zuul";

    @Bean
    public SentinelZuulProperties sentinelZuulProperties() {
        SentinelZuulProperties properties = new SentinelZuulProperties();
        String enabledStr = this.environment.getProperty("spring.cloud.sentinel.zuul.enabled");
        String preOrderStr = this.environment.getProperty("spring.cloud.sentinel.zuul.order.pre");
        String postOrderStr = this.environment.getProperty("spring.cloud.sentinel.zuul.order.post");
        String errorOrderStr = this.environment.getProperty("spring.cloud.sentinel.zuul.order.error");
        if (StringUtil.isNotEmpty((String)enabledStr)) {
            Boolean enabled = Boolean.valueOf(enabledStr);
            properties.setEnabled(enabled.booleanValue());
        }
        if (StringUtil.isNotEmpty((String)preOrderStr)) {
            properties.getOrder().setPre(Integer.parseInt(preOrderStr));
        }
        if (StringUtil.isNotEmpty((String)postOrderStr)) {
            properties.getOrder().setPost(Integer.parseInt(postOrderStr));
        }
        if (StringUtil.isNotEmpty((String)errorOrderStr)) {
            properties.getOrder().setError(Integer.parseInt(errorOrderStr));
        }
        return properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={UrlCleaner.class})
    public UrlCleaner urlCleaner() {
        return new DefaultUrlCleaner();
    }

    @Bean
    @ConditionalOnMissingBean(value={RequestOriginParser.class})
    public RequestOriginParser requestOriginParser() {
        return new DefaultRequestOriginParser();
    }

    @Bean
    public ZuulFilter preFilter(SentinelZuulProperties sentinelZuulProperties, UrlCleaner urlCleaner, RequestOriginParser requestOriginParser) {
        return new SentinelPreFilter(sentinelZuulProperties, urlCleaner, requestOriginParser);
    }

    @Bean
    public ZuulFilter postFilter(SentinelZuulProperties sentinelZuulProperties) {
        return new SentinelPostFilter(sentinelZuulProperties);
    }

    @Bean
    public ZuulFilter errorFilter(SentinelZuulProperties sentinelZuulProperties) {
        return new SentinelErrorFilter(sentinelZuulProperties);
    }

    @Bean
    public FallBackProviderHandler fallBackProviderListener(DefaultListableBeanFactory beanFactory) {
        return new FallBackProviderHandler(beanFactory);
    }
}

