/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class HibernateExtensionPostProcessor
implements BeanFactoryPostProcessor {
    private String sessionFactoryBeanName = "sessionFactory";
    private List mappingResources;
    private List annotatedClasses;
    private List configLocations;
    private Properties hibernateProperties;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        if (configurableListableBeanFactory.containsBean(this.sessionFactoryBeanName)) {
            List existingMappingResources;
            PropertyValue propertyValue;
            BeanDefinition sessionFactoryBeanDefinition = configurableListableBeanFactory.getBeanDefinition(this.sessionFactoryBeanName);
            MutablePropertyValues propertyValues = sessionFactoryBeanDefinition.getPropertyValues();
            if (this.mappingResources != null) {
                propertyValue = propertyValues.getPropertyValue("mappingResources");
                if (propertyValue == null) {
                    propertyValue = new PropertyValue("mappingResources", new ArrayList());
                    propertyValues.addPropertyValue(propertyValue);
                }
                existingMappingResources = (List)propertyValue.getValue();
                existingMappingResources.addAll(this.mappingResources);
            }
            if (this.annotatedClasses != null) {
                propertyValue = propertyValues.getPropertyValue("annotatedClasses");
                if (propertyValue == null) {
                    propertyValue = new PropertyValue("annotatedClasses", new ArrayList());
                    propertyValues.addPropertyValue(propertyValue);
                }
                existingMappingResources = (List)propertyValue.getValue();
                existingMappingResources.addAll(this.annotatedClasses);
            }
            if (this.configLocations != null) {
                propertyValue = propertyValues.getPropertyValue("configLocations");
                if (propertyValue == null) {
                    propertyValue = new PropertyValue("configLocations", new ArrayList());
                    propertyValues.addPropertyValue(propertyValue);
                }
                List existingConfigLocations = (List)propertyValue.getValue();
                existingConfigLocations.addAll(this.configLocations);
            }
            if (this.hibernateProperties != null) {
                propertyValue = propertyValues.getPropertyValue("hibernateProperties");
                if (propertyValue == null) {
                    propertyValue = new PropertyValue("hibernateProperties", (Object)new Properties());
                    propertyValues.addPropertyValue(propertyValue);
                }
                Properties existingHibernateProperties = (Properties)propertyValue.getValue();
                existingHibernateProperties.putAll((Map<?, ?>)this.hibernateProperties);
            }
        } else {
            throw new NoSuchBeanDefinitionException("No bean named [" + this.sessionFactoryBeanName + "] exists within the bean factory. " + "Cannot post process session factory to add Hibernate resource definitions.");
        }
    }

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    public void setMappingResources(List mappingResources) {
        this.mappingResources = mappingResources;
    }

    public void setAnnotatedClasses(List annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public void setConfigLocations(List configLocations) {
        this.configLocations = configLocations;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }
}

