/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.hibernate;

import java.util.List;
import javax.persistence.Table;
import org.appfuse.dao.UserDao;
import org.appfuse.dao.hibernate.GenericDaoHibernate;
import org.appfuse.model.User;
import org.hibernate.SessionFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="userDao")
public class UserDaoHibernate
extends GenericDaoHibernate<User, Long>
implements UserDao,
UserDetailsService {
    public UserDaoHibernate() {
        super(User.class);
    }

    @Override
    public List<User> getUsers() {
        return this.getHibernateTemplate().find("from User u order by upper(u.username)");
    }

    @Override
    public User saveUser(User user) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("user's id: " + user.getId()));
        }
        this.getHibernateTemplate().saveOrUpdate((Object)user);
        this.getHibernateTemplate().flush();
        return user;
    }

    @Override
    public User save(User user) {
        return this.saveUser(user);
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        List users = this.getHibernateTemplate().find("from User where username=?", (Object)username);
        if (users == null || users.isEmpty()) {
            throw new UsernameNotFoundException("user '" + username + "' not found...");
        }
        return (UserDetails)users.get(0);
    }

    @Override
    public String getUserPassword(String username) {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(SessionFactoryUtils.getDataSource((SessionFactory)this.getSessionFactory()));
        Table table = (Table)AnnotationUtils.findAnnotation(User.class, Table.class);
        return (String)jdbcTemplate.queryForObject("select password from " + table.name() + " where username=?", String.class, new Object[]{username});
    }
}

