/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.dao.GenericDao;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDaoHibernate<T, PK extends Serializable>
implements GenericDao<T, PK> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Class<T> persistentClass;
    private HibernateTemplate hibernateTemplate;
    private SessionFactory sessionFactory;

    public GenericDaoHibernate(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public GenericDaoHibernate(Class<T> persistentClass, SessionFactory sessionFactory) {
        this.persistentClass = persistentClass;
        this.sessionFactory = sessionFactory;
        this.hibernateTemplate = new HibernateTemplate(sessionFactory);
    }

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Autowired
    @Required
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.hibernateTemplate = new HibernateTemplate(sessionFactory);
    }

    @Override
    public List<T> getAll() {
        return this.hibernateTemplate.loadAll(this.persistentClass);
    }

    @Override
    public List<T> getAllDistinct() {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getAll());
        return new ArrayList<T>(result);
    }

    @Override
    public T get(PK id) {
        Object entity = this.hibernateTemplate.get(this.persistentClass, id);
        if (entity == null) {
            this.log.warn((Object)("Uh oh, '" + this.persistentClass + "' object with id '" + id + "' not found..."));
            throw new ObjectRetrievalFailureException(this.persistentClass, id);
        }
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        Object entity = this.hibernateTemplate.get(this.persistentClass, id);
        return entity != null;
    }

    @Override
    public T save(T object) {
        return (T)this.hibernateTemplate.merge(object);
    }

    @Override
    public void remove(PK id) {
        this.hibernateTemplate.delete(this.get(id));
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        String[] params = new String[queryParams.size()];
        Object[] values = new Object[queryParams.size()];
        int index = 0;
        Iterator<String> i$ = queryParams.keySet().iterator();
        while (i$.hasNext()) {
            String s;
            params[index] = s = i$.next();
            values[index++] = queryParams.get(s);
        }
        return this.hibernateTemplate.findByNamedQueryAndNamedParam(queryName, params, values);
    }
}

