/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.form;

import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Field;
import java.util.Map;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.impl.form.EnumFormType;
import org.activiti.explorer.ui.form.AbstractFormPropertyRenderer;

public class EnumFormPropertyRenderer
extends AbstractFormPropertyRenderer {
    public EnumFormPropertyRenderer() {
        super(EnumFormType.class);
    }

    @Override
    public Field getPropertyField(FormProperty formProperty) {
        ComboBox comboBox = new ComboBox(this.getPropertyLabel(formProperty));
        comboBox.setRequired(formProperty.isRequired());
        comboBox.setRequiredError(this.getMessage("form.field.required", this.getPropertyLabel(formProperty)));
        comboBox.setEnabled(formProperty.isWritable());
        comboBox.setNullSelectionAllowed(false);
        Object firstItemId = null;
        Object itemToSelect = null;
        Map values = (Map)formProperty.getType().getInformation("values");
        if (values != null) {
            for (Map.Entry enumEntry : values.entrySet()) {
                String selectedValue;
                comboBox.addItem(enumEntry.getKey());
                if (firstItemId == null) {
                    firstItemId = enumEntry.getKey();
                }
                if ((selectedValue = formProperty.getValue()) != null && selectedValue.equals(enumEntry.getKey())) {
                    itemToSelect = enumEntry.getKey();
                }
                if (enumEntry.getValue() == null) continue;
                comboBox.setItemCaption(enumEntry.getKey(), (String)enumEntry.getValue());
            }
        }
        if (itemToSelect != null) {
            comboBox.select(itemToSelect);
        } else if (firstItemId != null) {
            comboBox.select(firstItemId);
        }
        return comboBox;
    }
}

