/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.jedis;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class JedisLockProvider
implements LockProvider {
    private static final String KEY_PREFIX = "job-lock";
    private static final String ENV_DEFAULT = "default";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_IF_EXIST = "XX";
    private static final String SET_EXPIRE_TIME_IN_MS = "PX";
    private Pool<Jedis> jedisPool;
    private String environment;

    public JedisLockProvider(Pool<Jedis> jedisPool) {
        this(jedisPool, ENV_DEFAULT);
    }

    public JedisLockProvider(Pool<Jedis> jedisPool, String environment) {
        this.jedisPool = jedisPool;
        this.environment = environment;
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        long expireTime = JedisLockProvider.getMsUntil(lockConfiguration.getLockAtMostUntil());
        String key = JedisLockProvider.buildKey(lockConfiguration.getName(), this.environment);
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String rez = jedis.set(key, JedisLockProvider.buildValue(), SET_IF_NOT_EXIST, SET_EXPIRE_TIME_IN_MS, expireTime);
            if (rez != null && "OK".equals(rez)) {
                Optional<SimpleLock> optional = Optional.of(new RedisLock(key, this.jedisPool, lockConfiguration));
                return optional;
            }
        }
        return Optional.empty();
    }

    private static long getMsUntil(Instant instant) {
        return Duration.between(Instant.now(), instant).toMillis();
    }

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown host";
        }
    }

    static String buildKey(String lockName, String env) {
        return String.format("%s:%s:%s", KEY_PREFIX, env, lockName);
    }

    private static String buildValue() {
        return String.format("ADDED:%s@%s", Instant.now().toString(), JedisLockProvider.getHostname());
    }

    private static final class RedisLock
    implements SimpleLock {
        private final String key;
        private final Pool<Jedis> jedisPool;
        private final LockConfiguration lockConfiguration;

        private RedisLock(String key, Pool<Jedis> jedisPool, LockConfiguration lockConfiguration) {
            this.key = key;
            this.jedisPool = jedisPool;
            this.lockConfiguration = lockConfiguration;
        }

        public void unlock() {
            block15: {
                long keepLockFor = JedisLockProvider.getMsUntil(this.lockConfiguration.getLockAtLeastUntil());
                if (keepLockFor <= 0L) {
                    try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                        jedis.del(this.key);
                        break block15;
                    }
                    catch (Exception e) {
                        throw new LockException("Can not remove node", (Throwable)e);
                    }
                }
                try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                    jedis.set(this.key, JedisLockProvider.buildValue(), JedisLockProvider.SET_IF_EXIST, JedisLockProvider.SET_EXPIRE_TIME_IN_MS, keepLockFor);
                }
            }
        }
    }
}

