/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpAdapter;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpHandler;
import brave.http.HttpSampler;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;

public final class HttpClientHandler<Req, Resp>
extends HttpHandler {
    final Tracer tracer;
    @Nullable
    final HttpClientAdapter<Req, Resp> adapter;
    final Sampler sampler;
    final HttpSampler httpSampler;
    @Nullable
    final String serverName;
    final TraceContext.Injector<HttpClientRequest> defaultInjector;

    public static HttpClientHandler<HttpClientRequest, HttpClientResponse> create(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        return new HttpClientHandler<HttpClientRequest, HttpClientResponse>(httpTracing, null);
    }

    @Deprecated
    public static <Req, Resp> HttpClientHandler<Req, Resp> create(HttpTracing httpTracing, HttpClientAdapter<Req, Resp> adapter) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        if (adapter == null) {
            throw new NullPointerException("adapter == null");
        }
        return new HttpClientHandler<Req, Resp>(httpTracing, adapter);
    }

    HttpClientHandler(HttpTracing httpTracing, HttpClientAdapter<Req, Resp> adapter) {
        super(httpTracing.tracing().currentTraceContext(), httpTracing.clientParser());
        this.adapter = adapter;
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.tracing().sampler();
        this.httpSampler = httpTracing.clientSampler();
        this.serverName = !"".equals(httpTracing.serverName()) ? httpTracing.serverName() : null;
        this.defaultInjector = httpTracing.tracing().propagation().injector(HttpClientRequest.SETTER);
    }

    public Span handleSend(HttpClientRequest request) {
        HttpClientRequest.Adapter adapter = new HttpClientRequest.Adapter(request);
        return this.handleSend(new HttpClientRequest.Adapter(request), this.nextSpan(adapter));
    }

    Span handleSend(HttpClientRequest.Adapter adapter, Span span) {
        this.defaultInjector.inject(span.context(), (Object)adapter.delegate);
        return this.handleStart(adapter, adapter.unwrapped, span);
    }

    public Span handleSend(HttpClientRequest request, Span span) {
        HttpClientRequest.Adapter adapter = new HttpClientRequest.Adapter(request);
        return this.handleSend(adapter, span);
    }

    @Deprecated
    public Span handleSend(TraceContext.Injector<Req> injector, Req request) {
        return this.handleSend(injector, request, request);
    }

    @Deprecated
    public <C> Span handleSend(TraceContext.Injector<C> injector, C carrier, Req request) {
        return this.handleSend(injector, carrier, request, this.nextSpan(request));
    }

    @Deprecated
    public Span handleSend(TraceContext.Injector<Req> injector, Req request, Span span) {
        return this.handleSend(injector, request, request, span);
    }

    @Deprecated
    public <C> Span handleSend(TraceContext.Injector<C> injector, C carrier, Req request, Span span) {
        injector.inject(span.context(), carrier);
        return this.handleStart(this.adapter, request, span);
    }

    <Req1> void parseRequest(HttpAdapter<Req1, ?> adapter, Req1 request, Span span) {
        span.kind(Span.Kind.CLIENT);
        if (this.serverName != null) {
            span.remoteServiceName(this.serverName);
        }
        this.parser.request(adapter, request, span.customizer());
    }

    public Span nextSpan(Req request) {
        if (request instanceof HttpClientRequest) {
            return this.nextSpan(new HttpClientRequest.Adapter((HttpClientRequest)request));
        }
        Sampler override = this.httpSampler.toSampler(this.adapter, request, this.sampler);
        return this.tracer.withSampler(override).nextSpan();
    }

    Span nextSpan(HttpClientRequest.Adapter adapter) {
        Sampler override = this.httpSampler.toSampler(adapter, adapter.unwrapped, this.sampler);
        return this.tracer.withSampler(override).nextSpan();
    }

    public void handleReceive(@Nullable Resp response, @Nullable Throwable error, Span span) {
        if (response instanceof HttpClientResponse) {
            HttpClientResponse.Adapter adapter = new HttpClientResponse.Adapter((HttpClientResponse)response);
            this.handleFinish(adapter, adapter.unwrapped, error, span);
        } else {
            this.handleFinish(this.adapter, response, error, span);
        }
    }
}

