/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.type.ddl;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingjdbc.core.parsing.parser.token.IndexToken;
import io.shardingjdbc.core.routing.type.RoutingEngine;
import io.shardingjdbc.core.routing.type.RoutingResult;
import io.shardingjdbc.core.routing.type.simple.SimpleRoutingEngine;
import io.shardingjdbc.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.util.List;

public final class DDLRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final List<Object> parameters;
    private final DDLStatement ddlStatement;

    @Override
    public RoutingResult route() {
        return new SimpleRoutingEngine(this.shardingRule, this.parameters, this.getLogicTableName(), this.ddlStatement).route();
    }

    private String getLogicTableName() {
        if (this.ddlStatement.getTables().isEmpty()) {
            return this.shardingRule.getLogicTableName(this.getIndexToken().getIndexName());
        }
        return this.ddlStatement.getTables().getSingleTableName();
    }

    private IndexToken getIndexToken() {
        Preconditions.checkState((1 == this.ddlStatement.getSqlTokens().size() ? 1 : 0) != 0);
        return (IndexToken)this.ddlStatement.getSqlTokens().get(0);
    }

    @ConstructorProperties(value={"shardingRule", "parameters", "ddlStatement"})
    public DDLRoutingEngine(ShardingRule shardingRule, List<Object> parameters, DDLStatement ddlStatement) {
        this.shardingRule = shardingRule;
        this.parameters = parameters;
        this.ddlStatement = ddlStatement;
    }
}

