/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.sql.dml.insert;

import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.parser.dialect.mysql.sql.MySQLInsertParser;
import io.shardingjdbc.core.parsing.parser.dialect.oracle.sql.OracleInsertParser;
import io.shardingjdbc.core.parsing.parser.dialect.postgresql.sql.PostgreSQLInsertParser;
import io.shardingjdbc.core.parsing.parser.dialect.sqlserver.sql.SQLServerInsertParser;
import io.shardingjdbc.core.parsing.parser.sql.dml.insert.AbstractInsertParser;
import io.shardingjdbc.core.rule.ShardingRule;

public final class InsertParserFactory {
    public static AbstractInsertParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLInsertParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleInsertParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerInsertParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLInsertParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private InsertParserFactory() {
    }
}

