/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.merger.common;

import io.shardingjdbc.core.merger.ResultSetMerger;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class AbstractStreamResultSetMerger
implements ResultSetMerger {
    private ResultSet currentResultSet;
    private boolean wasNull;

    protected ResultSet getCurrentResultSet() throws SQLException {
        if (null == this.currentResultSet) {
            throw new SQLException("Current ResultSet is null, ResultSet perhaps end of next.");
        }
        return this.currentResultSet;
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Object result = Object.class == type ? this.getCurrentResultSet().getObject(columnIndex) : (Boolean.TYPE == type ? Boolean.valueOf(this.getCurrentResultSet().getBoolean(columnIndex)) : (Byte.TYPE == type ? Byte.valueOf(this.getCurrentResultSet().getByte(columnIndex)) : (Short.TYPE == type ? Short.valueOf(this.getCurrentResultSet().getShort(columnIndex)) : (Integer.TYPE == type ? Integer.valueOf(this.getCurrentResultSet().getInt(columnIndex)) : (Long.TYPE == type ? Long.valueOf(this.getCurrentResultSet().getLong(columnIndex)) : (Float.TYPE == type ? Float.valueOf(this.getCurrentResultSet().getFloat(columnIndex)) : (Double.TYPE == type ? Double.valueOf(this.getCurrentResultSet().getDouble(columnIndex)) : (String.class == type ? this.getCurrentResultSet().getString(columnIndex) : (BigDecimal.class == type ? this.getCurrentResultSet().getBigDecimal(columnIndex) : (byte[].class == type ? (Object)this.getCurrentResultSet().getBytes(columnIndex) : (Date.class == type ? this.getCurrentResultSet().getDate(columnIndex) : (Time.class == type ? this.getCurrentResultSet().getTime(columnIndex) : (Timestamp.class == type ? this.getCurrentResultSet().getTimestamp(columnIndex) : (URL.class == type ? this.getCurrentResultSet().getURL(columnIndex) : (Blob.class == type ? this.getCurrentResultSet().getBlob(columnIndex) : (Clob.class == type ? this.getCurrentResultSet().getClob(columnIndex) : (SQLXML.class == type ? this.getCurrentResultSet().getSQLXML(columnIndex) : (Reader.class == type ? this.getCurrentResultSet().getCharacterStream(columnIndex) : this.getCurrentResultSet().getObject(columnIndex)))))))))))))))))));
        this.wasNull = this.getCurrentResultSet().wasNull();
        return result;
    }

    @Override
    public Object getValue(String columnLabel, Class<?> type) throws SQLException {
        Object result = Object.class == type ? this.getCurrentResultSet().getObject(columnLabel) : (Boolean.TYPE == type ? Boolean.valueOf(this.getCurrentResultSet().getBoolean(columnLabel)) : (Byte.TYPE == type ? Byte.valueOf(this.getCurrentResultSet().getByte(columnLabel)) : (Short.TYPE == type ? Short.valueOf(this.getCurrentResultSet().getShort(columnLabel)) : (Integer.TYPE == type ? Integer.valueOf(this.getCurrentResultSet().getInt(columnLabel)) : (Long.TYPE == type ? Long.valueOf(this.getCurrentResultSet().getLong(columnLabel)) : (Float.TYPE == type ? Float.valueOf(this.getCurrentResultSet().getFloat(columnLabel)) : (Double.TYPE == type ? Double.valueOf(this.getCurrentResultSet().getDouble(columnLabel)) : (String.class == type ? this.getCurrentResultSet().getString(columnLabel) : (BigDecimal.class == type ? this.getCurrentResultSet().getBigDecimal(columnLabel) : (byte[].class == type ? (Object)this.getCurrentResultSet().getBytes(columnLabel) : (Date.class == type ? this.getCurrentResultSet().getDate(columnLabel) : (Time.class == type ? this.getCurrentResultSet().getTime(columnLabel) : (Timestamp.class == type ? this.getCurrentResultSet().getTimestamp(columnLabel) : (URL.class == type ? this.getCurrentResultSet().getURL(columnLabel) : (Blob.class == type ? this.getCurrentResultSet().getBlob(columnLabel) : (Clob.class == type ? this.getCurrentResultSet().getClob(columnLabel) : (SQLXML.class == type ? this.getCurrentResultSet().getSQLXML(columnLabel) : (Reader.class == type ? this.getCurrentResultSet().getCharacterStream(columnLabel) : this.getCurrentResultSet().getObject(columnLabel)))))))))))))))))));
        this.wasNull = this.getCurrentResultSet().wasNull();
        return result;
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        java.util.Date result;
        if (Date.class == type) {
            result = this.getCurrentResultSet().getDate(columnIndex, calendar);
        } else if (Time.class == type) {
            result = this.getCurrentResultSet().getTime(columnIndex, calendar);
        } else if (Timestamp.class == type) {
            result = this.getCurrentResultSet().getTimestamp(columnIndex, calendar);
        } else {
            throw new SQLException(String.format("Unsupported type: %s", type));
        }
        this.wasNull = this.getCurrentResultSet().wasNull();
        return result;
    }

    @Override
    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) throws SQLException {
        java.util.Date result;
        if (Date.class == type) {
            result = this.getCurrentResultSet().getDate(columnLabel, calendar);
        } else if (Time.class == type) {
            result = this.getCurrentResultSet().getTime(columnLabel, calendar);
        } else if (Timestamp.class == type) {
            result = this.getCurrentResultSet().getTimestamp(columnLabel, calendar);
        } else {
            throw new SQLException(String.format("Unsupported type: %s", type));
        }
        this.wasNull = this.getCurrentResultSet().wasNull();
        return result;
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        InputStream result;
        if ("Ascii".equals(type)) {
            result = this.getCurrentResultSet().getAsciiStream(columnIndex);
        } else if ("Unicode".equals(type)) {
            result = this.getCurrentResultSet().getUnicodeStream(columnIndex);
        } else if ("Binary".equals(type)) {
            result = this.getCurrentResultSet().getBinaryStream(columnIndex);
        } else {
            throw new SQLException(String.format("Unsupported type: %s", type));
        }
        this.wasNull = this.getCurrentResultSet().wasNull();
        return result;
    }

    @Override
    public InputStream getInputStream(String columnLabel, String type) throws SQLException {
        InputStream result;
        if ("Ascii".equals(type)) {
            result = this.getCurrentResultSet().getAsciiStream(columnLabel);
        } else if ("Unicode".equals(type)) {
            result = this.getCurrentResultSet().getUnicodeStream(columnLabel);
        } else if ("Binary".equals(type)) {
            result = this.getCurrentResultSet().getBinaryStream(columnLabel);
        } else {
            throw new SQLException(String.format("Unsupported type: %s", type));
        }
        this.wasNull = this.getCurrentResultSet().wasNull();
        return result;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public void setCurrentResultSet(ResultSet currentResultSet) {
        this.currentResultSet = currentResultSet;
    }

    public void setWasNull(boolean wasNull) {
        this.wasNull = wasNull;
    }
}

