/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public final class ServiceDescriptor {
    private final String name;
    private final Collection<MethodDescriptor<?, ?>> methods;

    public ServiceDescriptor(String name, MethodDescriptor<?, ?> ... methods) {
        this(name, Arrays.asList(methods));
    }

    public ServiceDescriptor(String name, Collection<MethodDescriptor<?, ?>> methods) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.methods = Collections.unmodifiableList(new ArrayList(methods));
    }

    public String getName() {
        return this.name;
    }

    public Collection<MethodDescriptor<?, ?>> getMethods() {
        return this.methods;
    }
}

