/*
 * Decompiled with CFR 0.152.
 */
package com.excel.poi.common;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;

public class DateFormatUtil {
    private static final LoadingCache<String, SimpleDateFormat> LOAD_CACHE = CacheBuilder.newBuilder().maximumSize(5L).build((CacheLoader)new CacheLoader<String, SimpleDateFormat>(){

        public SimpleDateFormat load(String pattern) {
            return new SimpleDateFormat(pattern);
        }
    });

    public static Date parse(String pattern, String value) throws ExecutionException, ParseException {
        return ((SimpleDateFormat)LOAD_CACHE.get((Object)pattern)).parse(value);
    }

    public static String format(String pattern, Date value) throws ExecutionException {
        return ((SimpleDateFormat)LOAD_CACHE.get((Object)pattern)).format(value);
    }
}

