/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.yaml;

import de.alpharogroup.resourcebundle.properties.PropertiesFileExtensions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.yaml.snakeyaml.Yaml;

public final class YamlToPropertiesExtensions {
    private static final Yaml YAML_CONVERTER = new Yaml();

    public static Properties toProperties(String yamlFilename) throws IOException {
        String propertiesAsString = YamlToPropertiesExtensions.toPropertyEntries(YamlToPropertiesExtensions.toTreeMap(Paths.get(yamlFilename, new String[0])), "=");
        File file = File.createTempFile("properties", null);
        FileUtils.writeStringToFile((File)file, (String)propertiesAsString, (Charset)StandardCharsets.UTF_8);
        return PropertiesFileExtensions.loadProperties((File)file);
    }

    public static TreeMap<String, Object> toTreeMap(Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            TreeMap treeMap = (TreeMap)YAML_CONVERTER.loadAs(inputStream, TreeMap.class);
            return treeMap;
        }
    }

    private static String toPropertyEntries(TreeMap<String, Object> treeMap, String propertiesDelimiter) {
        StringBuilder sb = new StringBuilder();
        for (String key : treeMap.keySet()) {
            Object object = treeMap.get(key);
            if (object instanceof String) {
                String stringObject = (String)object;
                sb.append(key).append(propertiesDelimiter).append(stringObject).append("\n");
            }
            if (!(object instanceof Map)) continue;
            Map stringObjectMap = (Map)object;
            sb.append(YamlToPropertiesExtensions.toEntry(key, stringObjectMap, propertiesDelimiter));
        }
        return sb.toString();
    }

    private static String toEntry(String key, Map<String, Object> map, String propertiesDelimiter) {
        StringBuilder sb = new StringBuilder();
        for (String mapKey : map.keySet()) {
            if (map.get(mapKey) instanceof Map) {
                sb.append(YamlToPropertiesExtensions.toEntry(key + "." + mapKey, (Map)map.get(mapKey), propertiesDelimiter));
                continue;
            }
            sb.append(key).append(".").append(mapKey).append(propertiesDelimiter).append(map.get(mapKey).toString()).append("\n");
        }
        return sb.toString();
    }

    private YamlToPropertiesExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

