/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.yaml;

import com.anubhavshukla.p2y.converter.PropertiesToYamlConverter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;

public final class PropertiesToYamlExtensions {
    public static String toYamlString(@NonNull File propertiesFile) {
        if (propertiesFile == null) {
            throw new NullPointerException("propertiesFile is marked non-null but is null");
        }
        return PropertiesToYamlExtensions.toYamlString(propertiesFile.getAbsolutePath());
    }

    public static String toYamlString(@NonNull String propertiesFilename) {
        if (propertiesFilename == null) {
            throw new NullPointerException("propertiesFilename is marked non-null but is null");
        }
        PropertiesToYamlConverter propertiesToYamlConverter = new PropertiesToYamlConverter();
        return propertiesToYamlConverter.toYamlString(propertiesFilename);
    }

    public static void toYamlFile(@NonNull File propertiesFile, @NonNull File newYamlFileToWrite) throws IOException {
        if (propertiesFile == null) {
            throw new NullPointerException("propertiesFile is marked non-null but is null");
        }
        if (newYamlFileToWrite == null) {
            throw new NullPointerException("newYamlFileToWrite is marked non-null but is null");
        }
        String propertiesFilename = propertiesFile.getAbsolutePath();
        String yamlString = PropertiesToYamlExtensions.toYamlString(propertiesFilename);
        FileUtils.writeStringToFile((File)newYamlFileToWrite, (String)yamlString, (Charset)StandardCharsets.UTF_8);
    }

    private PropertiesToYamlExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

