/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.map;

import de.alpharogroup.collections.list.ListFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MapExtensions {
    public static <K, V> K getKeyFromValue(Map<K, V> map, V value) {
        Map.Entry<K, V> entry;
        K key = null;
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && !map.get(key = (K)(entry = iterator.next()).getKey()).equals(value)) {
        }
        return key;
    }

    public static <K, V> Collection<K> getKeysFromValue(Map<K, V> map, V value) {
        List<Object> keys = ListFactory.newArrayList(new Object[0]);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V val = entry.getValue();
            if (!val.equals(value)) continue;
            K key = entry.getKey();
            keys.add(key);
        }
        return keys;
    }

    public static <T> Map<T, T> toGenericMap(T[][] twoDimArray) {
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        for (T[] element : twoDimArray) {
            T key = element[0];
            T value = element[1];
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, String> toMap(String[][] twoDimArray) {
        return MapExtensions.toGenericMap(twoDimArray);
    }

    private MapExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

