/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.array;

import de.alpharogroup.collections.array.ArrayFactory;
import de.alpharogroup.collections.list.ListFactory;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public final class ArrayExtensions {
    public static <T> T[] removeAll(@NonNull T[] array, @NonNull T[] arrayToRemove) {
        if (array == null) {
            throw new NullPointerException("array is marked @NonNull but is null");
        }
        if (arrayToRemove == null) {
            throw new NullPointerException("arrayToRemove is marked @NonNull but is null");
        }
        List<T> list = ListFactory.newArrayList(array);
        List<T> listToRemove = ListFactory.newArrayList(arrayToRemove);
        list.removeAll(listToRemove);
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static <T> boolean contains(T[] array, T element) {
        return ArrayExtensions.indexOf(array, element) >= 0;
    }

    public static <T> T[] remove(@NonNull T[] array, int ... indexes) {
        if (array == null) {
            throw new NullPointerException("array is marked @NonNull but is null");
        }
        List<T> list = ListFactory.newArrayList(array);
        int lastIndex = indexes.length - 1;
        Arrays.sort(indexes);
        for (int i = lastIndex; -1 < i; --i) {
            int index = indexes[i];
            list.remove(index);
        }
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static <T> T[] removeFirst(@NonNull T[] original) {
        if (original == null) {
            throw new NullPointerException("original is marked @NonNull but is null");
        }
        return ArrayExtensions.remove(original, 0);
    }

    public static <T> T[] removeLast(@NonNull T[] original) {
        if (original == null) {
            throw new NullPointerException("original is marked @NonNull but is null");
        }
        return Arrays.copyOf(original, original.length - 1);
    }

    public static <T> T[] arraycopyWithSystem(T[] source, T[] destination) {
        if (source == null) {
            return null;
        }
        System.arraycopy(source, 0, destination, 0, source.length);
        return destination;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... array) {
        return Stream.of(array).collect(Collectors.toSet());
    }

    public static <T> List<T> asList(T[] array) {
        return ListFactory.newArrayList(array);
    }

    public static <T> T getFirst(T[] array) {
        if (array != null && array.length != 0) {
            return array[0];
        }
        return null;
    }

    public static <T> int getIndex(T[] array, T element) {
        return ArrayExtensions.indexOf(array, element);
    }

    public static <T> T getLast(T[] array) {
        if (array != null && array.length != 0) {
            int lastIndex = array.length - 1;
            return array[lastIndex];
        }
        return null;
    }

    public static <T> int getNextIndex(T[] array, T element) {
        int indexOfElement = ArrayExtensions.indexOf(array, element);
        if (indexOfElement == -1) {
            return indexOfElement;
        }
        int lastIndex = array.length - 1;
        if (indexOfElement == lastIndex) {
            return 0;
        }
        int nextIndex = indexOfElement + 1;
        return nextIndex;
    }

    public static <T> int[] getNextIndexes(T[] array, T element, int count) {
        if (element != null) {
            int[] nextIndexes = new int[count];
            T currentElement = element;
            for (int i = 0; i < count; ++i) {
                int nextIndex = ArrayExtensions.getNextIndex(array, currentElement);
                if (nextIndex == -1) {
                    return null;
                }
                nextIndexes[i] = nextIndex;
                currentElement = array[nextIndex];
            }
            return nextIndexes;
        }
        return null;
    }

    public static <T> int getPreviousIndex(T[] array, T element) {
        int lastIndex = array.length - 1;
        int indexOfElement = ArrayExtensions.indexOf(array, element);
        if (indexOfElement == -1) {
            return indexOfElement;
        }
        if (indexOfElement == 0) {
            return lastIndex;
        }
        int previousIndex = indexOfElement - 1;
        return previousIndex;
    }

    public static <T> int[] getPreviousIndexes(T[] array, T element, int count) {
        if (element != null) {
            int[] previousIndexes = new int[count];
            T currentElement = element;
            for (int i = 0; i < count; ++i) {
                int previousIndex = ArrayExtensions.getPreviousIndex(array, currentElement);
                if (previousIndex == -1) {
                    return null;
                }
                previousIndexes[i] = previousIndex;
                currentElement = array[previousIndex];
            }
            return previousIndexes;
        }
        return null;
    }

    public static <T> T[] intersection(@NonNull T[] one, @NonNull T[] other) {
        if (one == null) {
            throw new NullPointerException("one is marked @NonNull but is null");
        }
        if (other == null) {
            throw new NullPointerException("other is marked @NonNull but is null");
        }
        Object[] intersection = (Object[])Array.newInstance(one.getClass().getComponentType(), one.length);
        int j = 0;
        for (int i = 0; i < one.length; ++i) {
            if (!ArrayExtensions.contains(other, one[i])) continue;
            intersection[j++] = one[i];
        }
        return ArrayFactory.newSubArray(intersection, 0, j);
    }

    public static <T> int indexOf(T[] array, T element) {
        int indexOfElement = Arrays.asList(array).indexOf(element);
        return indexOfElement;
    }

    public static <T> boolean isFirst(T[] array, T element) {
        int indexOfElement = Arrays.asList(array).indexOf(element);
        return indexOfElement == 0;
    }

    public static <T> boolean isLast(T[] array, T element) {
        int lastIndex = array.length - 1;
        int indexOfElement = Arrays.asList(array).indexOf(element);
        return indexOfElement == lastIndex;
    }

    public static byte[][] splitInChunks(byte[] bytes, int chunkSize) {
        int count;
        int size = (bytes.length - 1) / chunkSize + 1;
        byte[][] dataChunks = new byte[size][];
        int to = bytes.length;
        int from = count * chunkSize;
        for (count = size - 1; -1 < count; --count) {
            dataChunks[count] = Arrays.copyOfRange(bytes, from, to);
            to = from;
            from = to - chunkSize;
        }
        return dataChunks;
    }

    public static <T> List<T> toList(T[] array) {
        return ArrayExtensions.asList(array);
    }

    private ArrayExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

