/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.number;

import de.alpharogroup.math.MathExtensions;
import de.alpharogroup.random.DefaultSecureRandom;
import de.alpharogroup.random.enums.RandomAlgorithm;
import de.alpharogroup.random.number.RandomNumberExtensions;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Random;
import lombok.NonNull;

public final class RandomPrimitivesExtensions {
    public static boolean randomBoolean() {
        return RandomPrimitivesExtensions.randomInt(2) == 0;
    }

    public static byte randomByte() {
        return (byte)RandomPrimitivesExtensions.randomInt(255);
    }

    public static byte[] randomByteArray(int length) {
        byte[] randomByteArray = new byte[length];
        byte[] randomByteBox = new byte[1];
        for (int i = 0; i < length; ++i) {
            if (RandomPrimitivesExtensions.randomBoolean()) {
                randomByteArray[i] = RandomPrimitivesExtensions.randomByte();
                continue;
            }
            DefaultSecureRandom.get().nextBytes(randomByteBox);
            randomByteArray[i] = randomByteBox[0];
        }
        return randomByteArray;
    }

    public static char randomChar() {
        if (DefaultSecureRandom.get().nextBoolean()) {
            return (char)(DefaultSecureRandom.get().nextInt(26) + 65);
        }
        return (char)DefaultSecureRandom.get().nextInt(10);
    }

    public static short randomShort() {
        if (DefaultSecureRandom.get().nextBoolean()) {
            return (short)(DefaultSecureRandom.get().nextInt(65536) - 32768);
        }
        return (short)DefaultSecureRandom.get().nextInt(32768);
    }

    public static char randomChar(String string) {
        return string.charAt(RandomPrimitivesExtensions.randomInt(string.length()));
    }

    public static long randomLong() {
        return RandomPrimitivesExtensions.randomLong(new Random(System.currentTimeMillis()).nextInt());
    }

    public static long randomLong(long range) {
        return RandomPrimitivesExtensions.randomLong(range, RandomAlgorithm.SECURE_RANDOM);
    }

    public static long randomLong(long range, @NonNull RandomAlgorithm algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        switch (algorithm) {
            case MATH_ABS: {
                return (long)(Math.abs(DefaultSecureRandom.get().nextDouble()) % (double)range);
            }
            case MATH_RANDOM: {
                return (long)(Math.random() * (double)range);
            }
            case RANDOM: {
                long random = (long)new Random(System.currentTimeMillis()).nextDouble() % range;
                return MathExtensions.isPositive((long)random) ? random : random * -1L;
            }
        }
        return (long)(DefaultSecureRandom.get().nextDouble() * (double)range);
    }

    public static long randomLongBetween(long start, long end) {
        return start + RandomPrimitivesExtensions.randomLong(end - start);
    }

    public static float randomFloat() {
        return RandomPrimitivesExtensions.randomFloat(DefaultSecureRandom.get().nextFloat());
    }

    public static double randomDouble(double range) {
        return RandomPrimitivesExtensions.randomDouble(range, RandomAlgorithm.SECURE_RANDOM);
    }

    public static double randomDouble(double range, @NonNull RandomAlgorithm algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        switch (algorithm) {
            case MATH_ABS: {
                return Math.abs(DefaultSecureRandom.get().nextDouble()) % range;
            }
            case MATH_RANDOM: {
                return Math.random() * range;
            }
            case RANDOM: {
                double random = new Random(System.currentTimeMillis()).nextDouble() % range;
                return MathExtensions.isPositive((double)random) ? random : random * -1.0;
            }
        }
        return DefaultSecureRandom.get().nextDouble() * range;
    }

    public static double randomDouble() {
        return RandomPrimitivesExtensions.randomDouble(Double.MAX_VALUE);
    }

    public static double randomDoubleBetween(double start, double end) {
        return start + RandomPrimitivesExtensions.randomDouble(end - start);
    }

    public static double randomDoubleBetween(double start, double end, String pattern) throws ParseException {
        DecimalFormat formatter = new DecimalFormat(pattern);
        String rd = formatter.format(RandomPrimitivesExtensions.randomDoubleBetween(start, end));
        Number randomDouble = formatter.parse(rd);
        return randomDouble.doubleValue();
    }

    public static float randomFloat(float range) {
        return RandomPrimitivesExtensions.randomFloat(range, RandomAlgorithm.SECURE_RANDOM);
    }

    public static float randomFloat(float range, @NonNull RandomAlgorithm algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        switch (algorithm) {
            case MATH_ABS: {
                return (float)(Math.abs(DefaultSecureRandom.get().nextDouble()) % (double)range);
            }
            case MATH_RANDOM: {
                return (float)(Math.random() * (double)range);
            }
            case RANDOM: {
                float random = (float)new Random(System.currentTimeMillis()).nextDouble() % range;
                return MathExtensions.isPositive((float)random) ? random : random * -1.0f;
            }
        }
        return (float)(DefaultSecureRandom.get().nextDouble() * (double)range);
    }

    public static float randomFloat(int afterComma, int beforeComma) {
        return Float.parseFloat(RandomPrimitivesExtensions.getRandomFloatString(afterComma, beforeComma));
    }

    private static String getRandomFloatString(int afterComma, int beforeComma) {
        return RandomNumberExtensions.getRandomNumericString(afterComma) + "." + RandomNumberExtensions.getRandomNumericString(beforeComma);
    }

    public static float randomFloatBetween(float start, float end) {
        return start + RandomPrimitivesExtensions.randomFloat(end - start);
    }

    public static float randomFloatBetween(float start, float end, String pattern) throws ParseException {
        DecimalFormat formatter = new DecimalFormat(pattern);
        String rf = formatter.format(RandomPrimitivesExtensions.randomFloatBetween(start, end));
        Number randomFloat = formatter.parse(rf);
        return randomFloat.floatValue();
    }

    public static int randomInt() {
        return RandomPrimitivesExtensions.randomInt(DefaultSecureRandom.get().nextInt());
    }

    public static int randomInt(int range) {
        return RandomPrimitivesExtensions.randomInt(range, RandomAlgorithm.SECURE_RANDOM);
    }

    public static int randomInt(int range, @NonNull RandomAlgorithm algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        switch (algorithm) {
            case MATH_ABS: {
                return Math.abs(DefaultSecureRandom.get().nextInt()) % range;
            }
            case MATH_RANDOM: {
                return (int)(Math.random() * (double)range);
            }
            case RANDOM: {
                int random = new Random(System.currentTimeMillis()).nextInt() % range;
                return MathExtensions.isPositive((int)random) ? random : random * -1;
            }
        }
        return (int)(DefaultSecureRandom.get().nextDouble() * (double)range);
    }

    public static int randomIntBetween(int start, int end) {
        return RandomPrimitivesExtensions.randomIntBetween(start, end, true, false);
    }

    public static int randomIntBetween(int start, int end, boolean includeMin, boolean includeMax) {
        int randomIntBetween = start + RandomPrimitivesExtensions.randomInt(end - start);
        if (includeMin && includeMax) {
            randomIntBetween = start + RandomPrimitivesExtensions.randomInt(end - (start + 1));
        }
        if (includeMin && !includeMax) {
            randomIntBetween = start + RandomPrimitivesExtensions.randomInt(end - start);
        }
        if (!includeMin && includeMax) {
            randomIntBetween = start + 1 + RandomPrimitivesExtensions.randomInt(end - (start + 1));
        }
        if (!includeMin && !includeMax) {
            randomIntBetween = start + 1 + RandomPrimitivesExtensions.randomInt(end - start);
        }
        return randomIntBetween;
    }

    public static int getRandomIntBetween(int minVolume, int maxVolume) {
        return minVolume + Math.abs(DefaultSecureRandom.get().nextInt()) % maxVolume;
    }

    private RandomPrimitivesExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

