/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.random.address;

import de.alpharogroup.random.number.RandomPrimitivesExtensions;
import de.alpharogroup.random.util.PropertiesLoader;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;

public final class RandomAddressExtensions {
    public static final String PROP_FILE_STREETS = "/resources/germanstreets.properties";
    public static final String PROP_FILE_ZIP_CITIES = "/resources/de_zip_city.properties";

    public static String getRandomStreet(Properties properties) throws IOException {
        Properties p = properties != null ? properties : PropertiesLoader.loadProperties(PROP_FILE_STREETS);
        int size = p.size();
        Object[] keys = p.keySet().toArray();
        String street = (String)p.get(keys[RandomPrimitivesExtensions.randomInt(size)]);
        return street;
    }

    public static String getRandomStreetWithNumber(Properties properties) throws IOException {
        String street = RandomAddressExtensions.getRandomStreet(properties);
        String streetWithNumber = street + " " + RandomPrimitivesExtensions.randomInt(200);
        return streetWithNumber;
    }

    public static String getRandomZip(Properties p) {
        Set<Object> keyset = p.keySet();
        Object[] keys = keyset.toArray();
        int randomIndex = RandomPrimitivesExtensions.randomInt(keys.length);
        String zip = (String)keys[randomIndex];
        return zip;
    }

    private RandomAddressExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

