/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public final class DefaultValue {
    private static final Map<Class<?>, Object> DEFAULT_VALUE = Collections.unmodifiableMap(new HashMap<Class<?>, Object>(){
        {
            this.put(Boolean.TYPE, false);
            this.put(Character.TYPE, Character.valueOf('\u0000'));
            this.put(Byte.TYPE, (byte)0);
            this.put(Short.TYPE, (short)0);
            this.put(Integer.TYPE, 0);
            this.put(Long.TYPE, 0L);
            this.put(Float.TYPE, Float.valueOf(0.0f));
            this.put(Double.TYPE, 0.0);
            this.put(Object.class, null);
            this.put(null, null);
            this.put(Void.TYPE, null);
        }
    });

    public static Object get(@NonNull Class<?> classType) {
        if (classType == null) {
            throw new NullPointerException("classType is marked non-null but is null");
        }
        Object defaultValue = DEFAULT_VALUE.get(classType);
        return defaultValue;
    }

    private DefaultValue() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

