/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.huc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URI;
import java.util.List;
import java.util.Map;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.InternalCache;
import okhttp3.internal.http.CacheStrategy;
import okhttp3.internal.huc.JavaApiConverter;
import okio.Okio;
import okio.Sink;

public final class CacheAdapter
implements InternalCache {
    private final ResponseCache delegate;

    public CacheAdapter(ResponseCache delegate) {
        this.delegate = delegate;
    }

    public ResponseCache getDelegate() {
        return this.delegate;
    }

    public Response get(Request request) throws IOException {
        CacheResponse javaResponse = this.getJavaCachedResponse(request);
        if (javaResponse == null) {
            return null;
        }
        return JavaApiConverter.createOkResponseForCacheGet(request, javaResponse);
    }

    public okhttp3.internal.http.CacheRequest put(Response response) throws IOException {
        HttpURLConnection connection;
        URI uri = response.request().url().uri();
        final CacheRequest request = this.delegate.put(uri, connection = JavaApiConverter.createJavaUrlConnectionForCachePut(response));
        if (request == null) {
            return null;
        }
        return new okhttp3.internal.http.CacheRequest(){

            public Sink body() throws IOException {
                OutputStream body = request.getBody();
                return body != null ? Okio.sink((OutputStream)body) : null;
            }

            public void abort() {
                request.abort();
            }
        };
    }

    public void remove(Request request) throws IOException {
    }

    public void update(Response cached, Response network) throws IOException {
    }

    public void trackConditionalCacheHit() {
    }

    public void trackResponse(CacheStrategy cacheStrategy) {
    }

    private CacheResponse getJavaCachedResponse(Request request) throws IOException {
        Map<String, List<String>> headers = JavaApiConverter.extractJavaHeaders(request);
        return this.delegate.get(request.url().uri(), request.method(), headers);
    }
}

