/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.File;
import java.io.IOException;
import java.net.CacheResponse;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import okhttp3.Cache;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.http.CacheRequest;
import okhttp3.internal.huc.JavaApiConverter;

public class AndroidShimResponseCache
extends ResponseCache {
    private final Cache delegate;

    private AndroidShimResponseCache(Cache delegate) {
        this.delegate = delegate;
    }

    public static AndroidShimResponseCache create(File directory, long maxSize) throws IOException {
        Cache cache = new Cache(directory, maxSize);
        return new AndroidShimResponseCache(cache);
    }

    public boolean isEquivalent(File directory, long maxSize) {
        Cache installedCache = this.getCache();
        return installedCache.directory().equals(directory) && installedCache.maxSize() == maxSize && !installedCache.isClosed();
    }

    public Cache getCache() {
        return this.delegate;
    }

    @Override
    public CacheResponse get(URI uri, String requestMethod, Map<String, List<String>> requestHeaders) throws IOException {
        Request okRequest = JavaApiConverter.createOkRequest(uri, requestMethod, requestHeaders);
        Response okResponse = this.delegate.internalCache.get(okRequest);
        if (okResponse == null) {
            return null;
        }
        return JavaApiConverter.createJavaCacheResponse(okResponse);
    }

    @Override
    public java.net.CacheRequest put(URI uri, URLConnection urlConnection) throws IOException {
        Response okResponse = JavaApiConverter.createOkResponseForCachePut(uri, urlConnection);
        if (okResponse == null) {
            return null;
        }
        CacheRequest okCacheRequest = this.delegate.internalCache.put(okResponse);
        if (okCacheRequest == null) {
            return null;
        }
        return JavaApiConverter.createJavaCacheRequest(okCacheRequest);
    }

    public long size() throws IOException {
        return this.delegate.size();
    }

    public long maxSize() {
        return this.delegate.maxSize();
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public int getNetworkCount() {
        return this.delegate.networkCount();
    }

    public int getHitCount() {
        return this.delegate.hitCount();
    }

    public int getRequestCount() {
        return this.delegate.requestCount();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void delete() throws IOException {
        this.delegate.delete();
    }
}

