/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.model.ResumeBlockInfo;
import com.qiniu.util.Crc32;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public final class StreamUploader {
    private final String upToken;
    private final String key;
    private final StringMap params;
    private final String mime;
    private final ArrayList<String> contexts;
    private final Configuration configuration;
    private final Client client;
    private final byte[] blockBuffer;
    private final InputStream stream;
    private long size;
    private String host;
    private int retryMax;

    public StreamUploader(Client client, String upToken, String key, InputStream stream, StringMap params, String mime, Configuration configuration) {
        this.configuration = configuration;
        this.client = client;
        this.upToken = upToken;
        this.key = key;
        this.params = params;
        this.mime = mime == null ? "application/octet-stream" : mime;
        this.contexts = new ArrayList();
        this.blockBuffer = new byte[0x400000];
        this.stream = stream;
        this.retryMax = configuration.retryMax;
    }

    public Response upload() throws QiniuException {
        try {
            Response response = this.upload0();
            return response;
        }
        finally {
            this.close();
        }
    }

    private Response upload0() throws QiniuException {
        if (this.host == null) {
            this.host = this.configuration.upHost(this.upToken);
        }
        long uploaded = 0L;
        int ret = 0;
        boolean retry = false;
        boolean eof = false;
        while (this.size == 0L && !eof) {
            int bufferIndex = 0;
            int blockSize = 0;
            while (ret != -1 && bufferIndex != this.blockBuffer.length) {
                try {
                    blockSize = this.blockBuffer.length - bufferIndex;
                    ret = this.stream.read(this.blockBuffer, bufferIndex, blockSize);
                }
                catch (IOException e) {
                    this.close();
                    throw new QiniuException(e);
                }
                if (ret != -1) {
                    bufferIndex += ret;
                    if (ret != 0) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                eof = true;
                this.size = uploaded + (long)bufferIndex;
            }
            long crc = Crc32.bytes(this.blockBuffer, 0, bufferIndex);
            Response response = null;
            QiniuException temp = null;
            try {
                response = this.makeBlock(this.blockBuffer, bufferIndex);
            }
            catch (QiniuException e) {
                if (e.code() < 0) {
                    this.host = this.configuration.upHostBackup(this.upToken);
                }
                if (e.response == null || e.response.needRetry()) {
                    retry = true;
                    temp = e;
                }
                this.close();
                throw e;
            }
            if (!retry) {
                ResumeBlockInfo blockInfo0 = response.jsonToObject(ResumeBlockInfo.class);
                if (blockInfo0.crc32 != crc) {
                    retry = true;
                    temp = new QiniuException(new Exception("block's crc32 is not match"));
                }
            }
            if (retry) {
                if (this.retryMax > 0) {
                    --this.retryMax;
                    try {
                        response = this.makeBlock(this.blockBuffer, bufferIndex);
                        retry = false;
                    }
                    catch (QiniuException e) {
                        this.close();
                        throw e;
                    }
                } else {
                    throw temp;
                }
            }
            ResumeBlockInfo blockInfo = response.jsonToObject(ResumeBlockInfo.class);
            this.contexts.add(blockInfo.ctx);
            uploaded += (long)bufferIndex;
        }
        this.close();
        try {
            return this.makeFile();
        }
        catch (QiniuException e) {
            return this.makeFile();
        }
    }

    private Response makeBlock(byte[] block, int blockSize) throws QiniuException {
        String url = this.host + "/mkblk/" + blockSize;
        return this.post(url, block, 0, blockSize);
    }

    private void close() {
        try {
            this.stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String fileUrl() {
        String url = this.host + "/mkfile/" + this.size + "/mimeType/" + UrlSafeBase64.encodeToString(this.mime);
        final StringBuilder b = new StringBuilder(url);
        if (this.key != null) {
            b.append("/key/");
            b.append(UrlSafeBase64.encodeToString(this.key));
        }
        if (this.params != null) {
            this.params.forEach(new StringMap.Consumer(){

                @Override
                public void accept(String key, Object value) {
                    b.append("/");
                    b.append(key);
                    b.append("/");
                    b.append(UrlSafeBase64.encodeToString("" + value));
                }
            });
        }
        return b.toString();
    }

    private Response makeFile() throws QiniuException {
        String url = this.fileUrl();
        String s = StringUtils.join(this.contexts, ",");
        return this.post(url, StringUtils.utf8Bytes(s));
    }

    private Response post(String url, byte[] data) throws QiniuException {
        return this.client.post(url, data, new StringMap().put("Authorization", "UpToken " + this.upToken));
    }

    private Response post(String url, byte[] data, int offset, int size) throws QiniuException {
        return this.client.post(url, data, offset, size, new StringMap().put("Authorization", "UpToken " + this.upToken), "application/octet-stream");
    }
}

