/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.core.utils.ApplicationUtils;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.Message;
import com.alibaba.nacos.naming.misc.Synchronizer;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.Response;
import java.util.HashMap;
import org.springframework.util.StringUtils;

public class ServerStatusSynchronizer
implements Synchronizer {
    @Override
    public void send(final String serverIP, Message msg) {
        if (StringUtils.isEmpty((Object)serverIP)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("serverStatus", msg.getData());
        String url = "http://" + serverIP + ":" + ApplicationUtils.getPort() + ApplicationUtils.getContextPath() + "/v1/ns" + "/operator/server/status";
        if (serverIP.contains(":")) {
            url = "http://" + serverIP + ApplicationUtils.getContextPath() + "/v1/ns" + "/operator/server/status";
        }
        try {
            HttpClient.asyncHttpGet(url, null, params, new AsyncCompletionHandler(){

                public Integer onCompleted(Response response) throws Exception {
                    if (response.getStatusCode() != 200) {
                        Loggers.SRV_LOG.warn("[STATUS-SYNCHRONIZE] failed to request serverStatus, remote server: {}", (Object)serverIP);
                        return 1;
                    }
                    return 0;
                }
            });
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("[STATUS-SYNCHRONIZE] failed to request serverStatus, remote server: {}", (Object)serverIP, (Object)e);
        }
    }

    @Override
    public Message get(String server, String key) {
        return null;
    }
}

