/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.core.utils.ApplicationUtils;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class HttpClient {
    private static final int TIME_OUT_MILLIS = 10000;
    private static final int CON_TIME_OUT_MILLIS = 5000;
    private static AsyncHttpClient asyncHttpClient;
    private static CloseableHttpClient postClient;

    public static HttpResult httpDelete(String url, List<String> headers, Map<String, String> paramValues) {
        return HttpClient.request(url, headers, paramValues, "", 5000, 10000, "UTF-8", "DELETE");
    }

    public static HttpResult httpGet(String url, List<String> headers, Map<String, String> paramValues) {
        return HttpClient.request(url, headers, paramValues, "", 5000, 10000, "UTF-8", "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult request(String url, List<String> headers, Map<String, String> paramValues, String body, int connectTimeout, int readTimeout, String encoding, String method) {
        HttpURLConnection conn = null;
        try {
            String encodedContent = HttpClient.encodingParams(paramValues, encoding);
            url = url + (StringUtils.isBlank((CharSequence)encodedContent) ? "" : "?" + encodedContent);
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setRequestMethod(method);
            HttpClient.setHeaders(conn, headers, encoding);
            if (StringUtils.isNotBlank((CharSequence)body)) {
                conn.setDoOutput(true);
                byte[] b = body.getBytes();
                conn.setRequestProperty("Content-Length", String.valueOf(b.length));
                conn.getOutputStream().write(b, 0, b.length);
                conn.getOutputStream().flush();
                conn.getOutputStream().close();
            }
            conn.connect();
            HttpResult httpResult = HttpClient.getResult(conn);
            IoUtils.closeQuietly((HttpURLConnection)conn);
            return httpResult;
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("Exception while request: {}, caused: {}", (Object)url, (Object)e);
            HttpResult httpResult = new HttpResult(500, e.toString(), Collections.emptyMap());
            return httpResult;
        }
        finally {
            IoUtils.closeQuietly(conn);
        }
    }

    public static void asyncHttpGet(String url, List<String> headers, Map<String, String> paramValues, AsyncCompletionHandler handler) throws Exception {
        HttpClient.asyncHttpRequest(url, headers, paramValues, handler, "GET");
    }

    public static void asyncHttpPost(String url, List<String> headers, Map<String, String> paramValues, AsyncCompletionHandler handler) throws Exception {
        HttpClient.asyncHttpRequest(url, headers, paramValues, handler, "POST");
    }

    public static void asyncHttpDelete(String url, List<String> headers, Map<String, String> paramValues, AsyncCompletionHandler handler) throws Exception {
        HttpClient.asyncHttpRequest(url, headers, paramValues, handler, "DELETE");
    }

    public static void asyncHttpRequest(String url, List<String> headers, Map<String, String> paramValues, AsyncCompletionHandler handler, String method) throws Exception {
        AsyncHttpClient.BoundRequestBuilder builder;
        if (!MapUtils.isEmpty(paramValues)) {
            String encodedContent = HttpClient.encodingParams(paramValues, "UTF-8");
            url = url + (null == encodedContent ? "" : "?" + encodedContent);
        }
        switch (method) {
            case "GET": {
                builder = asyncHttpClient.prepareGet(url);
                break;
            }
            case "POST": {
                builder = asyncHttpClient.preparePost(url);
                break;
            }
            case "PUT": {
                builder = asyncHttpClient.preparePut(url);
                break;
            }
            case "DELETE": {
                builder = asyncHttpClient.prepareDelete(url);
                break;
            }
            default: {
                throw new RuntimeException("not supported method:" + method);
            }
        }
        if (!CollectionUtils.isEmpty(headers)) {
            for (String header : headers) {
                builder.setHeader(header.split("=")[0], header.split("=")[1]);
            }
        }
        builder.setHeader("Accept-Charset", "UTF-8");
        if (handler != null) {
            builder.execute((AsyncHandler)handler);
        } else {
            builder.execute();
        }
    }

    public static void asyncHttpPostLarge(String url, List<String> headers, String content, AsyncCompletionHandler handler) throws Exception {
        HttpClient.asyncHttpPostLarge(url, headers, content.getBytes(), handler);
    }

    public static void asyncHttpPostLarge(String url, List<String> headers, byte[] content, AsyncCompletionHandler handler) throws Exception {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.preparePost(url);
        if (!CollectionUtils.isEmpty(headers)) {
            for (String header : headers) {
                builder.setHeader(header.split("=")[0], header.split("=")[1]);
            }
        }
        builder.setBody(content);
        builder.setHeader("Content-Type", "application/json; charset=UTF-8");
        builder.setHeader("Accept-Charset", "UTF-8");
        builder.setHeader("Accept-Encoding", "gzip");
        builder.setHeader("Content-Encoding", "gzip");
        if (handler != null) {
            builder.execute((AsyncHandler)handler);
        } else {
            builder.execute();
        }
    }

    public static void asyncHttpDeleteLarge(String url, List<String> headers, String content, AsyncCompletionHandler handler) throws Exception {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.prepareDelete(url);
        if (!CollectionUtils.isEmpty(headers)) {
            for (String header : headers) {
                builder.setHeader(header.split("=")[0], header.split("=")[1]);
            }
        }
        builder.setBody(content.getBytes());
        builder.setHeader("Content-Type", "application/json; charset=UTF-8");
        builder.setHeader("Accept-Charset", "UTF-8");
        builder.setHeader("Accept-Encoding", "gzip");
        builder.setHeader("Content-Encoding", "gzip");
        if (handler != null) {
            builder.execute((AsyncHandler)handler);
        } else {
            builder.execute();
        }
    }

    public static HttpResult httpPost(String url, List<String> headers, Map<String, String> paramValues) {
        return HttpClient.httpPost(url, headers, paramValues, "UTF-8");
    }

    public static HttpResult httpPost(String url, List<String> headers, Map<String, String> paramValues, String encoding) {
        try {
            HeaderElement[] headerElements;
            HttpPost httpost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).setRedirectsEnabled(true).setMaxRedirects(5).build();
            httpost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : paramValues.entrySet()) {
                nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, encoding));
            CloseableHttpResponse response = postClient.execute((HttpUriRequest)httpost);
            HttpEntity entity = response.getEntity();
            String charset = encoding;
            if (entity.getContentType() != null && (headerElements = entity.getContentType().getElements()) != null && headerElements.length > 0 && headerElements[0] != null && headerElements[0].getParameterByName("charset") != null) {
                charset = headerElements[0].getParameterByName("charset").getValue();
            }
            return new HttpResult(response.getStatusLine().getStatusCode(), IoUtils.toString((InputStream)entity.getContent(), (String)charset), Collections.emptyMap());
        }
        catch (Throwable e) {
            return new HttpResult(500, e.toString(), Collections.emptyMap());
        }
    }

    public static void asyncHttpPutLarge(String url, Map<String, String> headers, byte[] content, AsyncCompletionHandler handler) throws Exception {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.preparePut(url);
        if (!headers.isEmpty()) {
            for (String headerKey : headers.keySet()) {
                builder.setHeader(headerKey, headers.get(headerKey));
            }
        }
        builder.setBody(content);
        builder.setHeader("Content-Type", "application/json; charset=UTF-8");
        builder.setHeader("Accept-Charset", "UTF-8");
        builder.setHeader("Accept-Encoding", "gzip");
        builder.setHeader("Content-Encoding", "gzip");
        if (handler != null) {
            builder.execute((AsyncHandler)handler);
        } else {
            builder.execute();
        }
    }

    public static void asyncHttpGetLarge(String url, Map<String, String> headers, byte[] content, AsyncCompletionHandler handler) throws Exception {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.prepareGet(url);
        if (!headers.isEmpty()) {
            for (String headerKey : headers.keySet()) {
                builder.setHeader(headerKey, headers.get(headerKey));
            }
        }
        builder.setBody(content);
        builder.setHeader("Content-Type", "application/json; charset=UTF-8");
        builder.setHeader("Accept-Charset", "UTF-8");
        builder.setHeader("Accept-Encoding", "gzip");
        builder.setHeader("Content-Encoding", "gzip");
        if (handler != null) {
            builder.execute((AsyncHandler)handler);
        } else {
            builder.execute();
        }
    }

    public static HttpResult httpPutLarge(String url, Map<String, String> headers, byte[] content) {
        try {
            HttpClientBuilder builder = HttpClients.custom().setUserAgent(UtilsAndCommons.SERVER_VERSION).setConnectionTimeToLive(500L, TimeUnit.MILLISECONDS);
            CloseableHttpClient httpClient = builder.build();
            HttpPut httpPut = new HttpPut(url);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPut.setHeader(entry.getKey(), entry.getValue());
            }
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(content, ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
            HttpEntity entity = response.getEntity();
            HeaderElement[] headerElements = entity.getContentType().getElements();
            String charset = headerElements[0].getParameterByName("charset").getValue();
            return new HttpResult(response.getStatusLine().getStatusCode(), IoUtils.toString((InputStream)entity.getContent(), (String)charset), Collections.emptyMap());
        }
        catch (Exception e) {
            return new HttpResult(500, e.toString(), Collections.emptyMap());
        }
    }

    public static HttpResult httpGetLarge(String url, Map<String, String> headers, String content) {
        try {
            HttpClientBuilder builder = HttpClients.custom();
            builder.setUserAgent(UtilsAndCommons.SERVER_VERSION);
            builder.setConnectionTimeToLive(500L, TimeUnit.MILLISECONDS);
            HttpGetWithEntity httpGetWithEntity = new HttpGetWithEntity();
            httpGetWithEntity.setURI(new URI(url));
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpGetWithEntity.setHeader(entry.getKey(), entry.getValue());
            }
            httpGetWithEntity.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (String)"UTF-8")));
            CloseableHttpClient httpClient = builder.build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGetWithEntity);
            HttpEntity entity = response.getEntity();
            HeaderElement[] headerElements = entity.getContentType().getElements();
            String charset = headerElements[0].getParameterByName("charset").getValue();
            return new HttpResult(response.getStatusLine().getStatusCode(), IoUtils.toString((InputStream)entity.getContent(), (String)charset), Collections.emptyMap());
        }
        catch (Exception e) {
            return new HttpResult(500, e.toString(), Collections.emptyMap());
        }
    }

    public static HttpResult httpPostLarge(String url, Map<String, String> headers, String content) {
        try {
            HttpClientBuilder builder = HttpClients.custom();
            builder.setUserAgent(UtilsAndCommons.SERVER_VERSION);
            builder.setConnectionTimeToLive(500L, TimeUnit.MILLISECONDS);
            CloseableHttpClient httpClient = builder.build();
            HttpPost httpost = new HttpPost(url);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpost.setHeader(entry.getKey(), entry.getValue());
            }
            httpost.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (String)"UTF-8")));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpost);
            HttpEntity entity = response.getEntity();
            HeaderElement[] headerElements = entity.getContentType().getElements();
            String charset = headerElements[0].getParameterByName("charset").getValue();
            return new HttpResult(response.getStatusLine().getStatusCode(), IoUtils.toString((InputStream)entity.getContent(), (String)charset), Collections.emptyMap());
        }
        catch (Exception e) {
            return new HttpResult(500, e.toString(), Collections.emptyMap());
        }
    }

    private static HttpResult getResult(HttpURLConnection conn) throws IOException {
        int respCode = conn.getResponseCode();
        InputStream inputStream = 200 == respCode ? conn.getInputStream() : conn.getErrorStream();
        HashMap<String, String> respHeaders = new HashMap<String, String>(conn.getHeaderFields().size());
        for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            respHeaders.put(entry.getKey(), entry.getValue().get(0));
        }
        String gzipEncoding = "gzip";
        if (gzipEncoding.equals(respHeaders.get("Content-Encoding"))) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return new HttpResult(respCode, IoUtils.toString((InputStream)inputStream, (String)HttpClient.getCharset(conn)), respHeaders);
    }

    private static String getCharset(HttpURLConnection conn) {
        String contentType = conn.getContentType();
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return "UTF-8";
        }
        String[] values = contentType.split(";");
        if (values.length == 0) {
            return "UTF-8";
        }
        String charset = "UTF-8";
        for (String value : values) {
            if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
            charset = value.substring("charset=".length());
        }
        return charset;
    }

    private static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
        conn.addRequestProperty("Accept-Charset", encoding);
        conn.addRequestProperty("Client-Version", VersionUtils.version);
        conn.addRequestProperty("User-Agent", UtilsAndCommons.SERVER_VERSION);
        conn.addRequestProperty("Request-Source", ApplicationUtils.getLocalAddress());
    }

    public static String encodingParams(Map<String, String> params, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == params || params.isEmpty()) {
            return null;
        }
        params.put("encoding", encoding);
        params.put("nofix", "1");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
            sb.append(entry.getKey()).append("=");
            sb.append(URLEncoder.encode(entry.getValue(), encoding));
            sb.append("&");
        }
        return sb.toString();
    }

    public static Map<String, String> translateParameterMap(Map<String, String[]> parameterMap) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (String key : parameterMap.keySet()) {
            map.put(key, parameterMap.get(key)[0]);
        }
        return map;
    }

    static {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setMaximumConnectionsTotal(-1);
        builder.setMaximumConnectionsPerHost(128);
        builder.setAllowPoolingConnection(true);
        builder.setFollowRedirects(false);
        builder.setIdleConnectionTimeoutInMs(10000);
        builder.setConnectionTimeoutInMs(5000);
        builder.setCompressionEnabled(true);
        builder.setIOThreadMultiplier(1);
        builder.setMaxRequestRetry(0);
        builder.setUserAgent(UtilsAndCommons.SERVER_VERSION);
        asyncHttpClient = new AsyncHttpClient(builder.build());
        HttpClientBuilder builder2 = HttpClients.custom();
        builder2.setUserAgent(UtilsAndCommons.SERVER_VERSION);
        builder2.setConnectionTimeToLive(5000L, TimeUnit.MILLISECONDS);
        builder2.setMaxConnPerRoute(-1);
        builder2.setMaxConnTotal(-1);
        builder2.disableAutomaticRetries();
        postClient = builder2.build();
    }

    public static class HttpGetWithEntity
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "GET";

        public String getMethod() {
            return METHOD_NAME;
        }
    }

    public static class HttpResult {
        public final int code;
        public final String content;
        private final Map<String, String> respHeaders;

        public HttpResult(int code, String content, Map<String, String> respHeaders) {
            this.code = code;
            this.content = content;
            this.respHeaders = respHeaders;
        }

        public String getHeader(String name) {
            return this.respHeaders.get(name);
        }
    }
}

