/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.auth.ActionTypes;
import com.alibaba.nacos.core.auth.Secured;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.utils.ApplicationUtils;
import com.alibaba.nacos.naming.cluster.ServerListManager;
import com.alibaba.nacos.naming.cluster.ServerStatusManager;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftCore;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.SwitchManager;
import com.alibaba.nacos.naming.push.PushService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/operator", "/v1/ns/ops"})
public class OperatorController {
    private final PushService pushService;
    private final SwitchManager switchManager;
    private final ServerListManager serverListManager;
    private final ServiceManager serviceManager;
    private final ServerMemberManager memberManager;
    private final ServerStatusManager serverStatusManager;
    private final SwitchDomain switchDomain;
    private final DistroMapper distroMapper;
    private final RaftCore raftCore;

    public OperatorController(PushService pushService, SwitchManager switchManager, ServerListManager serverListManager, ServiceManager serviceManager, ServerMemberManager memberManager, ServerStatusManager serverStatusManager, SwitchDomain switchDomain, DistroMapper distroMapper, RaftCore raftCore) {
        this.pushService = pushService;
        this.switchManager = switchManager;
        this.serverListManager = serverListManager;
        this.serviceManager = serviceManager;
        this.memberManager = memberManager;
        this.serverStatusManager = serverStatusManager;
        this.switchDomain = switchDomain;
        this.distroMapper = distroMapper;
        this.raftCore = raftCore;
    }

    @RequestMapping(value={"/push/state"})
    public ObjectNode pushState(@RequestParam(required=false) boolean detail, @RequestParam(required=false) boolean reset) {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        List<PushService.Receiver.AckEntry> failedPushes = PushService.getFailedPushes();
        int failedPushCount = this.pushService.getFailedPushCount();
        result.put("succeed", this.pushService.getTotalPush() - failedPushCount);
        result.put("total", this.pushService.getTotalPush());
        if (this.pushService.getTotalPush() > 0) {
            result.put("ratio", ((float)this.pushService.getTotalPush() - (float)failedPushCount) / (float)this.pushService.getTotalPush());
        } else {
            result.put("ratio", 0);
        }
        ArrayNode dataArray = JacksonUtils.createEmptyArrayNode();
        if (detail) {
            for (PushService.Receiver.AckEntry entry : failedPushes) {
                try {
                    dataArray.add(new String(entry.origin.getData(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    dataArray.add("[encoding failure]");
                }
            }
            result.replace("data", (JsonNode)dataArray);
        }
        if (reset) {
            PushService.resetPushState();
        }
        result.put("reset", reset);
        return result;
    }

    @GetMapping(value={"/switches"})
    public SwitchDomain switches(HttpServletRequest request) {
        return this.switchDomain;
    }

    @Secured(resource="naming/switches", action=ActionTypes.WRITE)
    @PutMapping(value={"/switches"})
    public String updateSwitch(@RequestParam(required=false) boolean debug, @RequestParam String entry, @RequestParam String value) throws Exception {
        this.switchManager.update(entry, value, debug);
        return "ok";
    }

    @Secured(resource="naming/metrics", action=ActionTypes.READ)
    @GetMapping(value={"/metrics"})
    public ObjectNode metrics(HttpServletRequest request) {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        int serviceCount = this.serviceManager.getServiceCount();
        int ipCount = this.serviceManager.getInstanceCount();
        int responsibleDomCount = this.serviceManager.getResponsibleServiceCount();
        int responsibleIpCount = this.serviceManager.getResponsibleInstanceCount();
        result.put("status", this.serverStatusManager.getServerStatus().name());
        result.put("serviceCount", serviceCount);
        result.put("instanceCount", ipCount);
        result.put("raftNotifyTaskCount", this.raftCore.getNotifyTaskCount());
        result.put("responsibleServiceCount", responsibleDomCount);
        result.put("responsibleInstanceCount", responsibleIpCount);
        result.put("cpu", ApplicationUtils.getCPU());
        result.put("load", ApplicationUtils.getLoad());
        result.put("mem", ApplicationUtils.getMem());
        return result;
    }

    @GetMapping(value={"/distro/server"})
    public ObjectNode getResponsibleServer4Service(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName) {
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        if (service == null) {
            throw new IllegalArgumentException("service not found");
        }
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("responsibleServer", this.distroMapper.mapSrv(serviceName));
        return result;
    }

    @GetMapping(value={"/distro/status"})
    public ObjectNode distroStatus(@RequestParam(defaultValue="view") String action) {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        if (StringUtils.equals((CharSequence)"view", (CharSequence)action)) {
            result.replace("status", JacksonUtils.transferToJsonNode((Object)this.memberManager.allMembers()));
            return result;
        }
        return result;
    }

    @GetMapping(value={"/servers"})
    public ObjectNode getHealthyServerList(@RequestParam(required=false) boolean healthy) {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        if (healthy) {
            List healthyMember = this.memberManager.allMembers().stream().filter(member -> member.getState() == NodeState.UP).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            result.replace("servers", JacksonUtils.transferToJsonNode((Object)healthyMember));
        } else {
            result.replace("servers", JacksonUtils.transferToJsonNode((Object)this.memberManager.allMembers()));
        }
        return result;
    }

    @Deprecated
    @RequestMapping(value={"/server/status"})
    public String serverStatus(@RequestParam String serverStatus) {
        this.serverListManager.onReceiveServerStatus(serverStatus);
        return "ok";
    }

    @PutMapping(value={"/log"})
    public String setLogLevel(@RequestParam String logName, @RequestParam String logLevel) {
        Loggers.setLogLevel(logName, logLevel);
        return "ok";
    }

    @Deprecated
    @RequestMapping(value={"/cluster/state"}, method={RequestMethod.GET})
    public JsonNode getClusterStates() {
        return JacksonUtils.transferToJsonNode((Object)this.serviceManager.getMySelfClusterState());
    }
}

