/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.raft;

import com.alibaba.nacos.naming.misc.GlobalExecutor;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public class RaftPeer {
    public String ip;
    public String voteFor;
    public AtomicLong term = new AtomicLong(0L);
    public volatile long leaderDueMs = RandomUtils.nextLong((long)0L, (long)GlobalExecutor.LEADER_TIMEOUT_MS);
    public volatile long heartbeatDueMs = RandomUtils.nextLong((long)0L, (long)GlobalExecutor.HEARTBEAT_INTERVAL_MS);
    public volatile State state = State.FOLLOWER;

    public void resetLeaderDue() {
        this.leaderDueMs = GlobalExecutor.LEADER_TIMEOUT_MS + RandomUtils.nextLong((long)0L, (long)GlobalExecutor.RANDOM_MS);
    }

    public void resetHeartbeatDue() {
        this.heartbeatDueMs = GlobalExecutor.HEARTBEAT_INTERVAL_MS;
    }

    public int hashCode() {
        return Objects.hash(this.ip);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RaftPeer)) {
            return false;
        }
        RaftPeer other = (RaftPeer)obj;
        return StringUtils.equals((CharSequence)this.ip, (CharSequence)other.ip);
    }

    public String toString() {
        return "RaftPeer{ip='" + this.ip + '\'' + ", voteFor='" + this.voteFor + '\'' + ", term=" + this.term + ", leaderDueMs=" + this.leaderDueMs + ", heartbeatDueMs=" + this.heartbeatDueMs + ", state=" + (Object)((Object)this.state) + '}';
    }

    public static enum State {
        LEADER,
        FOLLOWER,
        CANDIDATE;

    }
}

