/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency;

public class KeyBuilder {
    public static final String NAMESPACE_KEY_CONNECTOR = "##";
    private static final String EPHEMERAL_KEY_PREFIX = "ephemeral.";
    public static final String SERVICE_META_KEY_PREFIX = "com.alibaba.nacos.naming.domains.meta.";
    public static final String INSTANCE_LIST_KEY_PREFIX = "com.alibaba.nacos.naming.iplist.";
    public static final String BRIEF_SERVICE_META_KEY_PREFIX = "meta.";
    public static final String BRIEF_INSTANCE_LIST_KEY_PREFIX = "iplist.";

    private static String buildEphemeralInstanceListKey(String namespaceId, String serviceName) {
        return "com.alibaba.nacos.naming.iplist.ephemeral." + namespaceId + NAMESPACE_KEY_CONNECTOR + serviceName;
    }

    private static String buildPersistentInstanceListKey(String namespaceId, String serviceName) {
        return INSTANCE_LIST_KEY_PREFIX + namespaceId + NAMESPACE_KEY_CONNECTOR + serviceName;
    }

    public static String buildInstanceListKey(String namespaceId, String serviceName, boolean ephemeral) {
        return ephemeral ? KeyBuilder.buildEphemeralInstanceListKey(namespaceId, serviceName) : KeyBuilder.buildPersistentInstanceListKey(namespaceId, serviceName);
    }

    public static String buildServiceMetaKey(String namespaceId, String serviceName) {
        return SERVICE_META_KEY_PREFIX + namespaceId + NAMESPACE_KEY_CONNECTOR + serviceName;
    }

    public static String getSwitchDomainKey() {
        return "com.alibaba.nacos.naming.domains.meta.00-00---000-NACOS_SWITCH_DOMAIN-000---00-00";
    }

    public static boolean matchEphemeralInstanceListKey(String key) {
        return key.startsWith("com.alibaba.nacos.naming.iplist.ephemeral.");
    }

    public static boolean matchInstanceListKey(String key) {
        return key.startsWith(INSTANCE_LIST_KEY_PREFIX) || key.startsWith(BRIEF_INSTANCE_LIST_KEY_PREFIX);
    }

    public static boolean matchInstanceListKey(String key, String namespaceId, String serviceName) {
        return KeyBuilder.matchInstanceListKey(key) && KeyBuilder.matchServiceName(key, namespaceId, serviceName);
    }

    public static boolean matchServiceMetaKey(String key) {
        return key.startsWith(SERVICE_META_KEY_PREFIX) || key.startsWith(BRIEF_SERVICE_META_KEY_PREFIX);
    }

    public static boolean matchServiceMetaKey(String key, String namespaceId, String serviceName) {
        return KeyBuilder.matchServiceMetaKey(key) && KeyBuilder.matchServiceName(key, namespaceId, serviceName);
    }

    public static boolean matchSwitchKey(String key) {
        return key.endsWith("00-00---000-NACOS_SWITCH_DOMAIN-000---00-00") || key.endsWith("00-00---000-NACOS_SWITCH_DOMAIN-000---00-00.datum");
    }

    public static boolean matchServiceName(String key, String namespaceId, String serviceName) {
        return key.endsWith(namespaceId + NAMESPACE_KEY_CONNECTOR + serviceName);
    }

    public static boolean matchEphemeralKey(String key) {
        return KeyBuilder.matchEphemeralInstanceListKey(key);
    }

    public static boolean matchPersistentKey(String key) {
        return !KeyBuilder.matchEphemeralKey(key);
    }

    public static String briefInstanceListkey(String key) {
        return BRIEF_INSTANCE_LIST_KEY_PREFIX + key.split(INSTANCE_LIST_KEY_PREFIX)[1];
    }

    public static String briefServiceMetaKey(String key) {
        return BRIEF_SERVICE_META_KEY_PREFIX + key.split(SERVICE_META_KEY_PREFIX)[1];
    }

    public static String detailInstanceListkey(String key) {
        return INSTANCE_LIST_KEY_PREFIX.substring(0, INSTANCE_LIST_KEY_PREFIX.indexOf(BRIEF_INSTANCE_LIST_KEY_PREFIX)) + key;
    }

    public static String detailServiceMetaKey(String key) {
        return SERVICE_META_KEY_PREFIX.substring(0, SERVICE_META_KEY_PREFIX.indexOf(BRIEF_SERVICE_META_KEY_PREFIX)) + key;
    }

    public static String getNamespace(String key) {
        if (KeyBuilder.matchSwitchKey(key)) {
            return "";
        }
        if (KeyBuilder.matchServiceMetaKey(key)) {
            return key.split(NAMESPACE_KEY_CONNECTOR)[0].substring(SERVICE_META_KEY_PREFIX.length());
        }
        if (KeyBuilder.matchEphemeralInstanceListKey(key)) {
            return key.split(NAMESPACE_KEY_CONNECTOR)[0].substring(INSTANCE_LIST_KEY_PREFIX.length() + EPHEMERAL_KEY_PREFIX.length());
        }
        if (KeyBuilder.matchInstanceListKey(key)) {
            return key.split(NAMESPACE_KEY_CONNECTOR)[0].substring(INSTANCE_LIST_KEY_PREFIX.length());
        }
        return "";
    }

    public static String getServiceName(String key) {
        return key.split(NAMESPACE_KEY_CONNECTOR)[1];
    }
}

