/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.cluster;

import com.alibaba.nacos.naming.cluster.ServerStatus;
import com.alibaba.nacos.naming.consistency.ConsistencyService;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerStatusManager {
    @Resource(name="consistencyDelegate")
    private ConsistencyService consistencyService;
    @Autowired
    private SwitchDomain switchDomain;
    private ServerStatus serverStatus = ServerStatus.STARTING;

    @PostConstruct
    public void init() {
        GlobalExecutor.registerServerStatusUpdater(new ServerStatusUpdater());
    }

    private void refreshServerStatus() {
        if (StringUtils.isNotBlank((CharSequence)this.switchDomain.getOverriddenServerStatus())) {
            this.serverStatus = ServerStatus.valueOf(this.switchDomain.getOverriddenServerStatus());
            return;
        }
        this.serverStatus = this.consistencyService.isAvailable() ? ServerStatus.UP : ServerStatus.DOWN;
    }

    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    public class ServerStatusUpdater
    implements Runnable {
        @Override
        public void run() {
            ServerStatusManager.this.refreshServerStatus();
        }
    }
}

