/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.cluster;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberChangeListener;
import com.alibaba.nacos.core.cluster.MembersChangeEvent;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.utils.ApplicationUtils;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.Message;
import com.alibaba.nacos.naming.misc.NamingProxy;
import com.alibaba.nacos.naming.misc.ServerStatusSynchronizer;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.Synchronizer;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="serverListManager")
public class ServerListManager
extends MemberChangeListener {
    private static final String LOCALHOST_SITE = "unknown";
    private final SwitchDomain switchDomain;
    private final ServerMemberManager memberManager;
    private final Synchronizer synchronizer = new ServerStatusSynchronizer();
    private volatile List<Member> servers;

    public ServerListManager(SwitchDomain switchDomain, ServerMemberManager memberManager) {
        this.switchDomain = switchDomain;
        this.memberManager = memberManager;
        NotifyCenter.registerSubscriber((Subscriber)this);
        this.servers = new ArrayList<Member>(memberManager.allMembers());
    }

    @PostConstruct
    public void init() {
        GlobalExecutor.registerServerStatusReporter(new ServerStatusReporter(), 2000L);
        GlobalExecutor.registerServerInfoUpdater(new ServerInfoUpdater());
    }

    public boolean contains(String serverAddress) {
        for (Member server : this.getServers()) {
            if (!Objects.equals(serverAddress, server.getAddress())) continue;
            return true;
        }
        return false;
    }

    public List<Member> getServers() {
        return this.servers;
    }

    public void onEvent(MembersChangeEvent event) {
        this.servers = new ArrayList<Member>(event.getMembers());
    }

    public synchronized void onReceiveServerStatus(String configInfo) {
        Loggers.SRV_LOG.info("receive config info: {}", (Object)configInfo);
        String[] configs = configInfo.split("\r\n");
        if (configs.length == 0) {
            return;
        }
        for (String config : configs) {
            String[] params = config.split("#");
            if (params.length <= 3) {
                Loggers.SRV_LOG.warn("received malformed distro map data: {}", (Object)config);
                continue;
            }
            Member server = Optional.ofNullable(this.memberManager.find(params[1])).orElse(Member.builder().ip(params[1].split(":")[0]).state(NodeState.UP).port(Integer.parseInt(params[1].split(":")[1])).build());
            server.setExtendVal("site", (Object)params[0]);
            server.setExtendVal("weight", (Object)(params.length == 4 ? Integer.parseInt(params[3]) : 1));
            this.memberManager.update(server);
            if (this.contains(server.getAddress())) continue;
            throw new IllegalArgumentException("server: " + server.getAddress() + " is not in serverlist");
        }
    }

    private class ServerStatusReporter
    implements Runnable {
        private ServerStatusReporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (ApplicationUtils.getPort() <= 0) {
                    return;
                }
                int weight = Runtime.getRuntime().availableProcessors() / 2;
                if (weight <= 0) {
                    weight = 1;
                }
                long curTime = System.currentTimeMillis();
                String status = "unknown#" + ApplicationUtils.getLocalAddress() + "#" + curTime + "#" + weight + "\r\n";
                List<Member> allServers = ServerListManager.this.getServers();
                if (!ServerListManager.this.contains(ApplicationUtils.getLocalAddress())) {
                    Loggers.SRV_LOG.error("local ip is not in serverlist, ip: {}, serverlist: {}", (Object)ApplicationUtils.getLocalAddress(), allServers);
                    return;
                }
                if (allServers.size() > 0 && !ApplicationUtils.getLocalAddress().contains("127.0.0.1")) {
                    for (Member server : allServers) {
                        if (Objects.equals(server.getAddress(), ApplicationUtils.getLocalAddress())) continue;
                        if (server.getExtendVal("version") != null) {
                            Loggers.SRV_LOG.debug("[SERVER-STATUS] target {} has extend val {} = {}, use new api report status", new Object[]{server.getAddress(), "version", server.getExtendVal("version")});
                            continue;
                        }
                        Message msg = new Message();
                        msg.setData(status);
                        ServerListManager.this.synchronizer.send(server.getAddress(), msg);
                    }
                }
            }
            catch (Exception e) {
                Loggers.SRV_LOG.error("[SERVER-STATUS] Exception while sending server status", (Throwable)e);
            }
            finally {
                GlobalExecutor.registerServerStatusReporter(this, ServerListManager.this.switchDomain.getServerStatusSynchronizationPeriodMillis());
            }
        }
    }

    private class ServerInfoUpdater
    implements Runnable {
        private int cursor = 0;

        private ServerInfoUpdater() {
        }

        @Override
        public void run() {
            List members = ServerListManager.this.servers;
            if (members.isEmpty()) {
                return;
            }
            this.cursor = (this.cursor + 1) % members.size();
            Member target = (Member)members.get(this.cursor);
            if (Objects.equals(target.getAddress(), ApplicationUtils.getLocalAddress())) {
                return;
            }
            if (target.getExtendVal("version") != null) {
                return;
            }
            String path = "/operator/cluster/state";
            HashMap params = Maps.newHashMapWithExpectedSize((int)2);
            String server = target.getAddress();
            try {
                RaftPeer raftPeer;
                String content = NamingProxy.reqCommon("/operator/cluster/state", params, server, false);
                if (!"".equals(content) && null != (raftPeer = (RaftPeer)JacksonUtils.toObj((String)content, RaftPeer.class))) {
                    String json = JacksonUtils.toJson((Object)raftPeer);
                    Map map = (Map)JacksonUtils.toObj((String)json, HashMap.class);
                    target.setExtendVal("naming", (Object)map);
                    ServerListManager.this.memberManager.update(target);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

