/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.api;

import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import com.jfinal.weixin.sdk.api.PaymentApi;
import com.jfinal.weixin.sdk.kit.PaymentKit;
import com.jfinal.weixin.sdk.utils.PaymentException;
import com.jfinal.wxaapp.api.WxaOrder;
import java.util.HashMap;
import java.util.Map;

public class WxaPayApi {
    private static final Log log = Log.getLog(WxaPayApi.class);

    public static Map<String, String> unifiedOrder(WxaOrder order) throws PaymentException {
        String goodsTag;
        String timeExpire;
        String timeStart;
        String appid = order.getAppId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", appid);
        params.put("mch_id", order.getMchId());
        params.put("body", order.getBody());
        params.put("out_trade_no", order.getOutTradeNo());
        params.put("total_fee", order.getTotalFee());
        params.put("spbill_create_ip", order.getSpbillCreateIp());
        params.put("trade_type", PaymentApi.TradeType.JSAPI.name());
        params.put("nonce_str", System.currentTimeMillis() / 1000L + "");
        params.put("notify_url", order.getNotifyUrl());
        params.put("openid", order.getOpenId());
        String attach = order.getAttach();
        if (StrKit.notBlank((String)attach)) {
            params.put("attach", attach);
        }
        if (StrKit.notBlank((String)(timeStart = order.getTimeStart()))) {
            params.put("time_start", timeStart);
        }
        if (StrKit.notBlank((String)(timeExpire = order.getTimeExpire()))) {
            params.put("time_expire", timeExpire);
        }
        if (StrKit.notBlank((String)(goodsTag = order.getGoodsTag()))) {
            params.put("goods_tag", goodsTag);
        }
        String signKey = order.getSignKey();
        String sign = PaymentKit.createSign(params, signKey);
        params.put("sign", sign);
        String xmlResult = PaymentApi.pushOrder(params);
        if (log.isDebugEnabled()) {
            log.debug("wxaapp pushOrder xmlResult:" + xmlResult);
        }
        Map<String, String> result = PaymentKit.xmlToMap(xmlResult);
        String return_code = result.get("return_code");
        String return_msg = result.get("return_msg");
        if (StrKit.isBlank((String)return_code) || !"SUCCESS".equals(return_code)) {
            log.error(return_msg);
            throw new PaymentException(return_code, return_msg);
        }
        String result_code = result.get("result_code");
        if (StrKit.isBlank((String)result_code) || !"SUCCESS".equals(result_code)) {
            log.error(return_msg);
            String err_code_des = result.get("err_code_des");
            log.error(err_code_des);
            throw new PaymentException(return_code, err_code_des);
        }
        String prepay_id = result.get("prepay_id");
        HashMap<String, String> packageParams = new HashMap<String, String>();
        packageParams.put("appId", appid);
        packageParams.put("timeStamp", System.currentTimeMillis() / 1000L + "");
        packageParams.put("nonceStr", System.currentTimeMillis() + "");
        packageParams.put("package", "prepay_id=" + prepay_id);
        packageParams.put("signType", "MD5");
        String packageSign = PaymentKit.createSign(packageParams, signKey);
        packageParams.put("paySign", packageSign);
        return packageParams;
    }
}

