/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.gen;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.beetl.sql.ext.gen.CodeGen;

public class GenConfig {
    private String baseClass;
    private int spaceCount = 4;
    private boolean preferBigDecimal = true;
    private boolean preferDate = true;
    private String outputPackage = "com.test";
    private static final String defaultTemplatePath = "/org/beetl/sql/ext/gen/pojo.btl";
    private String encoding = "UTF-8";
    private String template = null;
    private boolean implSerializable = false;
    private String ignorePrefix = "";
    public List<CodeGen> codeGens = new ArrayList<CodeGen>();
    private boolean display = false;
    public String space = "    ";
    private int propertyOrder = 1;
    public static final int ORDER_BY_TYPE = 1;
    public static final int ORDER_BY_ORIGNAL = 2;

    public GenConfig() {
        this(defaultTemplatePath);
    }

    public GenConfig(String templatePath) {
        this.initTemplate(templatePath);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setSpaceCount(int spaceCount) {
        this.spaceCount = spaceCount;
    }

    public String getOutputPackage() {
        return this.outputPackage;
    }

    public void setOutputPackage(String outputPackage) {
        this.outputPackage = outputPackage;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public GenConfig setBaseClass(String baseClass) {
        this.baseClass = baseClass;
        return this;
    }

    public GenConfig setSpace(int count) {
        this.spaceCount = count;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(" ");
        }
        this.space = sb.toString();
        return this;
    }

    public GenConfig preferBigDecimal(boolean prefer) {
        this.preferBigDecimal = prefer;
        return this;
    }

    public GenConfig preferPrimitive(boolean primitive) {
        this.preferBigDecimal = primitive;
        return this;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public int getSpaceCount() {
        return this.spaceCount;
    }

    public boolean isPreferBigDecimal() {
        return this.preferBigDecimal;
    }

    public boolean isPreferDate() {
        return this.preferDate;
    }

    public void setPreferDate(boolean preferDate) {
        this.preferDate = preferDate;
    }

    public void setPreferBigDecimal(boolean preferBigDecimal) {
        this.preferBigDecimal = preferBigDecimal;
    }

    public String getSpace() {
        return this.space;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public GenConfig setDisplay(boolean display) {
        this.display = display;
        return this;
    }

    private void initTemplate(String classPath) {
        this.template = this.getTemplate(classPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemplate(String classPath) {
        String string;
        InputStream ins = GenConfig.class.getResourceAsStream(classPath);
        InputStreamReader reader = new InputStreamReader(ins, this.encoding);
        try {
            char[] buffer = new char[8192];
            int len = reader.read(buffer);
            string = new String(buffer, 0, len);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        reader.close();
        return string;
    }

    public int getPropertyOrder() {
        return this.propertyOrder;
    }

    public void setPropertyOrder(int propertyOrder) {
        this.propertyOrder = propertyOrder;
    }

    public boolean isImplSerializable() {
        return this.implSerializable;
    }

    public void setImplSerializable(boolean implSerializable) {
        this.implSerializable = implSerializable;
    }

    public String getIgnorePrefix() {
        return this.ignorePrefix;
    }

    public void setIgnorePrefix(String ignorePrefix) {
        this.ignorePrefix = ignorePrefix;
    }
}

